package com.ykcloud.soa.social.distribution.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * TODO（描述类的职责）
 *
 * @author zy
 * @date 2020/7/20 18:01
 */
public class DistributionSalespersonAchievementGetRequest extends AbstractRequest {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "分销员编号不能为空")
    private String leaderUsrNumId;//分销员编号

	private String inviteSalespersonUsrNumId;//分销员邀请人编号

    private Long  headEcShopNumId;//电商总店门店编号

    private Long  ecShopNumId;//电商门店编号

    @NotNull(message = "时间类型不能为空")
    private Integer timeType;//1.全部 2.今日 3.昨日 4.近7日 5.自定义时间

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDtme;//开始时间 yyyy-MM-dd HH:mm:ss

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDtme;//结束时间 yyyy-MM-dd HH:mm:ss

	public String getInviteSalespersonUsrNumId() {
		return inviteSalespersonUsrNumId;
	}

	public void setInviteSalespersonUsrNumId(String inviteSalespersonUsrNumId) {
		this.inviteSalespersonUsrNumId = inviteSalespersonUsrNumId;
	}

	public Integer getTimeType() {
        return timeType;
    }

    public void setTimeType(Integer timeType) {
        this.timeType = timeType;
    }

    public Long getEcShopNumId() {
        return ecShopNumId;
    }

    public void setEcShopNumId(Long ecShopNumId) {
        this.ecShopNumId = ecShopNumId;
    }

    public String getLeaderUsrNumId() {
        return leaderUsrNumId;
    }

    public void setLeaderUsrNumId(String leaderUsrNumId) {
        this.leaderUsrNumId = leaderUsrNumId;
    }

    public Long getHeadEcShopNumId() {
        return headEcShopNumId;
    }

    public void setHeadEcShopNumId(Long headEcShopNumId) {
        this.headEcShopNumId = headEcShopNumId;
    }

    public Date getBeginDtme() {
        return beginDtme;
    }

    public void setBeginDtme(Date beginDtme) {
        this.beginDtme = beginDtme;
    }

    public Date getEndDtme() {
        return endDtme;
    }

    public void setEndDtme(Date endDtme) {
        this.endDtme = endDtme;
    }
}
