package com.ykcloud.soa.social.distribution.api.request;

import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractUserSessionRequest;
import com.ykcloud.soa.social.distribution.api.model.DistributionSalespersonGradeUpgradeInfo;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class DistributionSalespersonGradeSaveRequest extends AbstractUserSessionRequest {

    private static final long serialVersionUID = 1L;

    private String series;//修改的时候传

    @ApiField(description = "网格员id")
    private Long salespersonGradeNumId;

    @ApiField(description = "等级名称")
    @NotBlank(message = "等级名称不能为空")
    private String salespersonGradeName;//KOC等级名称

    @ApiField(description = "等级类型: 1.网格员 2.KOC")
    @NotNull(message = "等级类型不能为空")
    private Integer salespersonGradeType;//等级类型: 1.网格员 2.KOC

    @ApiField(description = "启用状态：1: 启用 0：停用, 默认启用")
    private Integer openSign = 1;

    @ApiField(description = "升级条件 1:满足勾选条件其一即可 2:满足所有勾选条件")
    private Integer salespersonGradeUpgradeType;

    @ApiField(description = "降级条件 1:满足勾选条件其一即可 2:满足所有勾选条件")
    private Integer salespersonGradeDemotionType;

    @ApiField(description = "升级启用状态：1: 启用 0：停用")
    private Integer upgradeOpenSign;

    @ApiField(description = "降级启用状态：1: 启用 0：停用")
    private Integer demotionOpenSign;

    private List<DistributionSalespersonGradeUpgradeInfo> distributionSalespersonGradeUpgradeInfos;

    private List<DistributionSalespersonGradeUpgradeInfo> distributionSalespersonGradeDemoteInfos;


}
