package com.ykcloud.soa.social.distribution.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractUserSessionRequest;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * TODO（描述类的职责）
 *
 * @author zy
 * @date 2020/8/27 14:02
 */
@Data
public class DistributionSalespersonInfosExportRequest extends AbstractUserSessionRequest {

	private static final long serialVersionUID = 1L;

	@ApiField(description = "分销员手机号,默认查询全部")
	private String mobilePhone;//分销员手机号,默认查询全部

	@ApiField(description = "邀请方手机号,默认查询全部")
	private String inviteMobilePhone;//邀请方手机号,默认查询全部

	@ApiField(description = "KOC等级,默认为null查询全部")
	private Long salespersonGradeNumId;//KOC等级,默认为null查询全部

	@ApiField(description = "网格编号,默认为null查询全部")
	private Long  gridNumId;//网格编号,默认为null查询全部

	@ApiField(description = "开始时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date beginDtme;//开始时间

	@ApiField(description = "结束时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date endDtme;//结束时间

	@NotNull(message = "导出类型不能为空！")
	@ApiField(description = "导出类型：导出选中的分销员122、导出查询的分销员123")
	private Long exportFlag;

	@ApiField(description = "分销会员编号集合")
	private List<Long> leaderUsrNumIds;//分销会员编号集合
}
