package com.ykcloud.soa.social.distribution.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * TODO（描述类的职责）
 *
 * @author zy
 * @date 2020/7/22 15:09
 */
@Data
public class DistributionSalespersonInfosQueryRequest extends AbstractRequest {

    private static final long serialVersionUID = 1L;

    @ApiField(description = "分销员手机号,默认查询全部")
    private String mobilePhone;//分销员手机号,默认查询全部

    @ApiField(description = "邀请方手机号,默认查询全部")
    private String inviteMobilePhone;//邀请方手机号,默认查询全部

    @ApiField(description = "KOC等级,默认为null查询全部")
    private Long salespersonGradeNumId;//KOC等级,默认为null查询全部

    @ApiField(description = "网格编号,默认为null查询全部")
    private Long  gridNumId;//网格编号,默认为null查询全部

    @ApiField(description = "开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date beginDtme;//开始时间

    @ApiField(description = "结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endDtme;//结束时间

    @ApiField(description = "会员编号集合")
    private List<Long> leaderUsrNumIds;//会员编号集合

    @ApiField(description = "当前页")
    private Integer page = 1;//当前页

    @ApiField(description = "每页显示条数")
    private Integer pageSize = 10;//每页显示条数
}
