package com.ykcloud.soa.social.distribution.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;

import javax.validation.constraints.NotNull;
import java.util.Date;

public class DistributionSalespersonInfosStatisticsRequest extends AbstractRequest {

    private static final long serialVersionUID = -6081994594941251601L;

    @NotNull(message = "会员编号不能为空")
    private Long leadUserNumId;

    @NotNull(message = "会员类型不能为空")
    private String userType;

    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date beginDtme;            //开始时间(自定义使用)

    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date endDtme;             //结束时间(自定义使用)

    private Integer page;       //当前页

    private Integer pageSize;   //每页显示条数

    private Integer sortType; //排序类型

    private String mobilePhone; //手机号

    private String personnelName; //姓名

    public String getMobilePhone() {
        return mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getPersonnelName() {
        return personnelName;
    }

    public void setPersonnelName(String personnelName) {
        this.personnelName = personnelName;
    }

    public Integer getSortType() {
        return sortType;
    }

    public void setSortType(Integer sortType) {
        this.sortType = sortType;
    }

    public Long getLeadUserNumId() {
        return leadUserNumId;
    }

    public void setLeadUserNumId(Long leadUserNumId) {
        this.leadUserNumId = leadUserNumId;
    }

    public Date getBeginDtme() {
        return beginDtme;
    }

    public void setBeginDtme(Date beginDtme) {
        this.beginDtme = beginDtme;
    }

    public Date getEndDtme() {
        return endDtme;
    }

    public void setEndDtme(Date endDtme) {
        this.endDtme = endDtme;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getUserType() {
        return userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }
}
