package com.ykcloud.soa.social.distribution.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

public class DistributionSalespersonInfosZhQueryRequest extends AbstractRequest {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "电商总店门店编号不能为空！")
    private Long headEcShopNumId;//电商总店门店编号

    private String mobilePhone;            //分销员手机号
    private String inviteMobilePhone;            //邀请方手机号
    private Integer salespersonGradeNumId;            //分销员等级
    private Long distributionGroupNumId;            //分组编号
    private Integer joinDtmeType;            //加入时间类型 0：今天 1：昨天 2：近七天 3：近30天  7：自定义
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date beginDtme;            //开始时间(自定义使用)
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date endDtme;             //结束时间(自定义使用)

    private Integer page;       //当前页
    private Integer pageSize;   //每页显示条数

    @NotNull(message = "导出类型不能为空！")
    private Long exportFlag;//导出类型：导出选中的分销员122、导出查询的分销员123

    private List<String> usrNumIds;//会员编号

    public Long getHeadEcShopNumId() {
        return headEcShopNumId;
    }

    public void setHeadEcShopNumId(Long headEcShopNumId) {
        this.headEcShopNumId = headEcShopNumId;
    }

    public String getMobilePhone() {
        return mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getInviteMobilePhone() {
        return inviteMobilePhone;
    }

    public void setInviteMobilePhone(String inviteMobilePhone) {
        this.inviteMobilePhone = inviteMobilePhone;
    }

    public Integer getSalespersonGradeNumId() {
        return salespersonGradeNumId;
    }

    public void setSalespersonGradeNumId(Integer salespersonGradeNumId) {
        this.salespersonGradeNumId = salespersonGradeNumId;
    }

    public Long getDistributionGroupNumId() {
        return distributionGroupNumId;
    }

    public void setDistributionGroupNumId(Long distributionGroupNumId) {
        this.distributionGroupNumId = distributionGroupNumId;
    }

    public Integer getJoinDtmeType() {
        return joinDtmeType;
    }

    public void setJoinDtmeType(Integer joinDtmeType) {
        this.joinDtmeType = joinDtmeType;
    }

    public Date getBeginDtme() {
        return beginDtme;
    }

    public void setBeginDtme(Date beginDtme) {
        this.beginDtme = beginDtme;
    }

    public Date getEndDtme() {
        return endDtme;
    }

    public void setEndDtme(Date endDtme) {
        this.endDtme = endDtme;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Long getExportFlag() {
        return exportFlag;
    }

    public void setExportFlag(Long exportFlag) {
        this.exportFlag = exportFlag;
    }

    public List<String> getUsrNumIds() {
        return usrNumIds;
    }

    public void setUsrNumIds(List<String> usrNumIds) {
        this.usrNumIds = usrNumIds;
    }
}
