package com.ykcloud.soa.social.distribution.api.request;

import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractUserSessionRequest;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class DistributionSubordinatePerformancesQueryRequest extends AbstractUserSessionRequest {

    private static final long serialVersionUID = -1001036496634633583L;

    @ApiField(description = "上级KOC会员编号")
    @NotNull(message = "上级KOC会员编号不能为空")
    private Long leaderUsrNumId;//上级KOC会员编号

    @ApiField(description = "下级KOC会员名称")
    private String subordinateLeaderUsrName;//下级KOC会员名称

    @ApiField(description = "页数")
    private Integer page = 1;//页数

    @ApiField(description = "每页显示条数")
    private Integer pageSize = 10;//每页显示条数
}
