package com.ykcloud.soa.social.distribution.api.request;

import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractUserSessionRequest;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class DistributionTeamPerformancesQueryRequest extends AbstractUserSessionRequest {

    private static final long serialVersionUID = -3622787631231659871L;

    @ApiField(description = "上级KOC会员编号（团队领导人）")
    @NotNull(message = "上级KOC会员编号（团队领导人）不能为空")
    private Long inviteSalespersonUsrNumId;//上级KOC会员编号（团队领导人）

    @ApiField(description = "KOC会员名称（团队成员）")
    private String personnelName;//KOC会员名称（团队成员）

    @ApiField(description = "手机号（团队成员）")
    private String  mobilePhone;//手机号（团队成员）

    @ApiField(description = "当前页")
    private Integer page = 1;//当前页

    @ApiField(description = "每页显示条数")
    private Integer pageSize = 10;//每页显示条数
}
