package com.ykcloud.soa.social.distribution.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @Package: com.gb.soa.fullchannel.cmember.api.request
 * @ClassName: GetAnnualIndicatorByUserAndDateRequest
 * @Author: Dan
 * @Date: 2021/6/28 20:26
 */
@Data
public class GetAnnualIndicatorByUserAndDateRequest extends AbstractRequest {
    @NotNull(message = "用户编号不能为空!")
    private Long userNo;
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date queryDate;
    @NotNull(message = "指标类型不能为空!")
    private Long indicatorTypeNumId;
}
