package com.ykcloud.soa.social.distribution.api.request;

import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @Package: com.gb.soa.fullchannel.cmember.api.request
 * @ClassName: GetAnnualIndicatorRequest
 * @Author: Dan
 * @Date: 2021/6/25 16:14
 */
@Data
public class GetAnnualIndicatorRequest extends AbstractRequest {

    private static final long serialVersionUID = -4926873936601623139L;
    @NotNull(message = "等级编号不能为空!")
    private Integer salespersonGradeNumId;

    @NotNull(message = "指标类型不能为空!")
    private Integer indicatorTypeNumId;

    @NotNull(message = "当前页不能为空!")
    private Integer page = 1;

    @NotNull(message = "每页显示条数不能为空!")
    private Integer pageSize = 10;

    @NotNull(message = "查询年不能为空!")
    private String year;

    @ApiField(description = "员工编号或账号")
    private Long userNo;

    @ApiField(description = "姓名")
    private String userName;
}
