package com.ykcloud.soa.social.distribution.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author tz.x
 * @date 2021/6/28 9:41
 */
@Data
public class GridWorkBenchQueryRequest extends AbstractRequest {

    @NotNull(message = "网格类型不能为空")
    @ApiField(description = "1:基础网格员 2：增值网格员 3：网格长")
    private Integer gridType;

    @NotNull(message = "雇员编号不能为空")
    private Long empeNumId;
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date queryDate;
}
