package com.ykcloud.soa.social.distribution.api.request;

import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;
import com.ykcloud.soa.social.distribution.api.model.DistributionCommissionHdr;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
public class TeamDistributionCommissionUpdateRequest extends AbstractRequest {

    private static final long serialVersionUID = -8211361273277180656L;

    @ApiField(description = "订单编号")
    @NotNull(message = "订单编号不能为空")
    private String tmlNumId;

    @ApiField(description = "分销佣金")
    @NotNull(message = "分销佣金不能为空")
    private DistributionCommissionHdr commissionHdr;

    @ApiField(description = "收入状态 1：预计收入 2：确认收入")
    @NotNull(message = "收入状态不能为空")
    private Integer statusNumId;
}
