package com.ykcloud.soa.social.distribution.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author tz.x
 * @date 2021/6/25 13:18
 */
@Data
public class TeamPerformancesQueryRequest extends AbstractRequest {

    @ApiField(description="姓名")
    private String personnelName;

    @ApiField(description="手机号")
    private String mobilePhone;

    @NotNull(message = "时间不能为空!")
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date queryDate;
    @NotNull(message = "页数不能为空")
    private Integer page;

    @NotNull(message = "每页显示条数")
    private Integer pageSize;

    @NotNull(message = "雇员编号不能为空")
    private Long empeNumId;

}
