package com.ykcloud.soa.social.distribution.api.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.request.AbstractRequest;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class TotalListOrdersGetRequest extends AbstractRequest {
    @ApiField(
            description = "月初时间"
    )
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date beginDtme;
    @ApiField(
            description = "月末时间"
    )
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date endDtme;
    @ApiField(
            description = "查询的维度，0集团1区域2公司"
    )
    private Integer type = 2;

    @ApiField(
            description = "用户编号"
    )
    private Long empeNumId;
}
