package com.ykcloud.soa.social.distribution.api.response;

import com.gb.soa.omp.ccommon.api.annotation.ApiField;
import com.gb.soa.omp.ccommon.api.response.MessagePack;
import com.ykcloud.soa.social.distribution.api.model.DistributionOrderProfitDetail;
import lombok.Data;

import java.util.List;

@Data
public class DistributionOrderProfitDetailsQueryResponse extends MessagePack {

    private static final long serialVersionUID = 7182794327980792035L;

    @ApiField(description = "销售额")
    private Double totalOrderAmount;//订单金额

    @ApiField(description = "销售业绩金额")
    private Double totalSalePerformanceAmount = 0D;//销售业绩金额

    @ApiField(description = "已结算收益（元）")
    private Double totalCommissionAmount;//已结算收益（元）

    @ApiField(description = "待结算收益（元）")
    private Double availableTotalCommissionAmount;//待结算收益（元）

    @ApiField(description = "收益明细")
    private List<DistributionOrderProfitDetail> distributionOrderProfitDetailList;//收益明细

    @ApiField(description = "总数")
    private Integer totalCount;
}
