package com.ykcloud.soa.social.distribution.api.service;

import com.ykcloud.soa.social.distribution.api.request.*;
import com.ykcloud.soa.social.distribution.api.response.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 网格人员接口
 * @author tan.zhang
 *
 */
@FeignClient("social-distribution")
public interface GridMemberService {

	/**
	 * @author tz.x
	 * @date 2021/6/28 9:41
	 * 查询网格员工作台
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.queryGridWorkBench")
	GridWorkBenchQueryResponse queryGridWorkBench(@RequestBody GridWorkBenchQueryRequest request);
	/**
	 * @author tz.x
	 * @date 2021/6/28 9:41
	 * APP 查询网格长 业绩，koc , 会员 排行榜
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.getDirectlySubordinatesRanking")
	DirectlySubordinatesRankingResponse getDirectlySubordinatesRanking(@RequestBody DirectlySubordinatesRankingRequest request);

	/**
	 * @author tz.x
	 * @date 2021/6/28 9:41
	 * APP 查询本人业绩，koc , 会员 与 今日数据
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.getDirectlyByEmpeNumId")
	DirectlySubordinatesRankingResponse getDirectlyByEmpeNumId(@RequestBody DirectlySubordinatesRankingRequest request);
	/**
	 * 按 集团 公司 区域 查询排行榜 前十
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.getListTotalOrderAmount")
	TotalListOrdersGetResponse getListTotalOrderAmount(@RequestBody TotalListOrdersGetRequest request);


	/**
	 * @author tz.x
	 * @date 2021/6/26 11:53
	 * 获取下级列表
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.getSubordinates")
	SubordinatesGetResponse getSubordinates(@RequestBody SubordinatesGetRequest request);

	/**
	 * @author tz.x
	 * @date 2021/6/25 16:02
	 * 查询直属下属列表
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.getDirectlySubordinates")
	DirectlySubordinatesGetResponse getDirectlySubordinates(@RequestBody DirectlySubordinatesGetRequest request);

	/**
	 * @author tz.x
	 * @date 2021/6/25 13:18
	 * 网格人员团队销售业绩查询接口
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.queryTeamPerformances")
	TeamPerformancesQueryResponse queryTeamPerformances(@RequestBody TeamPerformancesQueryRequest request);

	/**
	 * @author tz.x
	 * @date 2021/6/23 20:19
	 * 查询网格人员详情
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.queryGridMemberDetailByEmpeNumId")
	GridMemberDetailResponse queryGridMemberDetailByEmpeNumId(@RequestBody GridMemberDetailRequest request);


	/**
	 * 查询网格员列表
	 * @param request
	 * @return
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.gridMemberListQuery")
	GridMemberQueryResponse gridMemberListQuery(@RequestBody GridMemberQueryRequest request);

	/**
	 * @Method
	 * @Author Dan
	 * @Description查询指标列表
	 * @Date 2021/6/25 16:13
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.getAnnualIndicator")
	GetAnnualIndicatorResponse getAnnualIndicator(@RequestBody GetAnnualIndicatorRequest request);

	/**
	 * @Method
	 * @Author Dan
	 * @Description更新指标
	 * @Date 2021/6/25 20:12
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.updateAnnualIndicator")
	UpdateAnnualIndicatorResponse updateAnnualIndicator(@RequestBody UpdateAnnualIndicatorRequest request);

	/**
	 * @Method
	 * @Author Dan
	 * @Description更新指标
	 * @Date 2021/6/25 20:12
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.batchUpdateAnnualIndicator")
	BatchUpdateAnnualIndicatorResponse batchUpdateAnnualIndicator(@RequestBody BatchUpdateAnnualIndicatorRequest request);

	/**
	 * @Method
	 * @Author Dan
	 * @Description根据人员编号以及日期获取到月份指标
	 * @Date 2021/6/28 20:25
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.getAnnualIndicatorByUserAndDate")
	GetAnnualIndicatorByUserAndDateResponse getAnnualIndicatorByUserAndDate(GetAnnualIndicatorByUserAndDateRequest request);


	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.gridMemberSync")
	MemberGridSyncResponse gridMemberSync(MemberGridSyncRequest request);

	/**
	 * 调整KOC上级为某增值网格员-调整
	 * @param request
	 * @return
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.changeKocInviteSalespersonEmpe")
	public KocInviteSalespersonEmpeChangeResponse changeKocInviteSalespersonEmpe(@RequestBody KocInviteSalespersonEmpeChangeRequest request);

	/**
	 * 指标导入
	 * @param request
	 * @return
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.importKocInviteSalespersonEmpe")
	KocInviteSalespersonEmpeImportResponse importKocInviteSalespersonEmpe(@RequestBody KocInviteSalespersonEmpeImportRequest request);

	/**
	 * 根据网格编号查询网格信息
	 */
	@PostMapping("/com.ykcloud.soa.social.distribution.api.service.GridMemberService.gridInfoGet")
	GridInfoGetResponse getGridInfo(@RequestBody GridInfoGetRequest request);
}
