package com.ykcloud.soa.social.distribution.api.service;

import com.ykcloud.soa.social.distribution.api.request.*;
import com.ykcloud.soa.social.distribution.api.response.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient("social-distribution")
public interface MemberDistributionService {


    /**
     * 判断是否可以分享
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.checkLeaderUsrNumId")
    LeaderUsrNumIdCheckResponse checkLeaderUsrNumId(@RequestBody LeaderUsrNumIdCheckRequest request);

    /**
     * 查询分销等级
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.getDistributionSalespersonGrade")
    DistributionSalespersonGradeGetResponse getDistributionSalespersonGrade(@RequestBody DistributionSalespersonGradeGetRequest request);

    /**
     * 分销员等级编辑
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.saveDistributionSalespersonGrade")
    DistributionSalespersonGradeSaveResponse saveDistributionSalespersonGrade(@RequestBody DistributionSalespersonGradeSaveRequest request);

    /**
     *修改分销等级开关
     * @param request
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.changeSalespersonGradeOpenSign")
    SalespersonGradeOpenSignChangeResponse changeSalespersonGradeOpenSign(@RequestBody SalespersonGradeOpenSignChangeRequest request);


    /**
     * 小程序等级中心
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.getMinDistributionSalespersonGradeInfo")
    MinDistributionSalespersonGradeInfoGetResponse getMinDistributionSalespersonGradeInfo(@RequestBody MinDistributionSalespersonGradeInfoGetRequest request);


    /**
     *  查询分销员中心开启配置
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.getDistributionOpenConfig")
    DistributionOpenConfigGetResponse getDistributionOpenConfig(@RequestBody DistributionOpenConfigGetRequest request);


    ///////////////////////  中燃  /////////////////////
    /**
     * 分销个人所得税设置编辑
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.saveDistributionPersonalIncomeTaxSetting")
    DistributionPersonalIncomeTaxSettingSaveResponse saveDistributionPersonalIncomeTaxSetting(@RequestBody DistributionPersonalIncomeTaxSettingSaveRequest request);

    /**
     * 分销个人所得税设置查询
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.getDistributionPersonalIncomeTaxSetting")
    DistributionPersonalIncomeTaxSettingGetResponse getDistributionPersonalIncomeTaxSetting(@RequestBody DistributionPersonalIncomeTaxSettingGetRequest request);


    /**
     * KOC分佣查询
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.getDistributionCommissionRule")
    KocCommissionRuleGetResponse getDistributionCommissionRule(@RequestBody KocCommissionRuleGetRequest request);


    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.saveDistributionCommissionRule")
    KocCommissionRuleSaveResponse saveDistributionCommissionRule(@RequestBody KocCommissionRuleSaveRequest request);




    /**
     * KOC列表查询
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.queryDistributionSalespersonInfos")
    DistributionSalespersonInfosQueryResponse queryDistributionSalespersonInfos(@RequestBody DistributionSalespersonInfosQueryRequest request);

    /**
     * 新增、编辑KOC信息
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.saveDistributionSalespersonInfo")
    DistributionSalespersonInfoSaveResponse saveDistributionSalespersonInfo(@RequestBody DistributionSalespersonInfoSaveRequest request);

    /**
     * 批量导入KOC
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.importDistributionSalespersonInfo")
    DistributionSalespersonInfoImportResponse importDistributionSalespersonInfo(@RequestBody DistributionSalespersonInfoImportRequest request);

    /**
     * KOC明细导出
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.exportDistributionSalespersonInfos")
    DistributionSalespersonInfosExportResponse exportDistributionSalespersonInfos(@RequestBody DistributionSalespersonInfosExportRequest request);


    /**
     * 查询KOC详情
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.getDistributionSalespersonDetail")
    DistributionSalespersonDetailGetResponse getDistributionSalespersonDetail(@RequestBody DistributionSalespersonDetailGetRequest request);

    /**
     * KOC客户查询-B端
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.queryDistributionCustomers")
    DistributionCustomersQueryResponse queryDistributionCustomers(@RequestBody DistributionCustomersQueryRequest request);


    /**
     * KOC客户查询-C端
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.queryDistributionCustomerList")
    DistributionCustomerListQueryResponse queryDistributionCustomerList(@RequestBody DistributionCustomerListQueryRequest request);

    /**
     * KOC/网格员客户详情查询
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.queryDistributionCustomerDetail")
    DistributionCustomerDetailQueryResponse queryDistributionCustomerDetail(@RequestBody DistributionCustomerDetailQueryRequest request);

    /**
     * KOC/增值网格员邀请列表页查询
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.queryDistributionInviteList")
    DistributionInviteListQueryResponse queryDistributionInviteList(@RequestBody DistributionInviteListQueryRequest request);

    /**
     * 通过会员编号获取分销员信息
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.getDistributionInfoByUsrNumId")
    DistributionInfoByUsrNumIdGetResponse getDistributionInfoByUsrNumId(@RequestBody DistributionInfoByUsrNumIdGetRequest request);

    /**
     * 通过雇员编号获取雇员信息
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.getEmpeInfosByEmpeNumIds")
    EmpeInfosByEmpeNumIdsGetResponse getEmpeInfosByEmpeNumIds(@RequestBody EmpeInfosByEmpeNumIdsGetRequest request);

    /**
     * 通过会员编号获取分销员信息和佣金规则
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.getDistributionInfoAndCommissionRule")
    DistributionInfoAndCommissionRuleGetResponse getDistributionInfoAndCommissionRule(@RequestBody DistributionInfoAndCommissionRuleGetRequest request);

    /**
     * 更新佣金
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.updateDistributionCommission")
    DistributionCommissionUpdateResponse updateDistributionCommission(@RequestBody DistributionCommissionUpdateRequest request);

    /**
     * 分销员升级
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.upgradeDistributionGrade")
    DistributionGradeUpgradeResponse upgradeDistributionGrade(@RequestBody DistributionGradeUpgradeRequest request);

    /**
     * 提现-收入明细查询
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.queryDistributionAccountDetailList")
    DistributionAccountDetailListQueryResponse queryDistributionAccountDetailList(@RequestBody DistributionAccountDetailListQueryRequest request);

    /**
     * 提现-提现记录查询
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.queryDistributionCashOutDetailList")
    DistributionCashOutDetailListQueryResponse queryDistributionCashOutDetailList(@RequestBody DistributionCashOutDetailListQueryRequest request);

    /**
     * 提现-提现佣金
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.cashOutDistributionCommission")
    DistributionCommissionCashOutResponse cashOutDistributionCommission(@RequestBody DistributionCommissionCashOutRequest request);


    /**
     * 提现-更新提现申请状态
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.updateCashOutStatus")
    CashOutStatusUpdateResponse updateCashOutStatus(@RequestBody CashOutStatusUpdateRequest request);


    /**
     * 提现-提现申请记录导出
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.exportDistributionCashOutDetails")
    DistributionCashOutDetailsExportResponse exportDistributionCashOutDetails(@RequestBody DistributionCashOutDetailsExportRequest request);

    /**
     * 提现-提现申请结果导入
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.importDistributionCashOutDetails")
    DistributionCashOutDetailsImportResponse importDistributionCashOutDetails(@RequestBody DistributionCashOutDetailsImportRequest request);

    /**
     * 查询员工归属信息
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.getEcShareEarnLeaderBelongInfo")
    EcShareEarnLeaderBelongInfoGetResponse getEcShareEarnLeaderBelongInfo(@RequestBody EcShareEarnLeaderBelongInfoGetRequest request);

    /**
     * 查询绑定银行卡
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.queryBindedBankCards")
    BindedBankCardsQueryResponse queryBindedBankCards(@RequestBody BindedBankCardsQueryRequest request);


    /**
     * 获取营业厅员工的所在门店编号
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.getSubUnitNumIdBySaleEmpeNumId")
    public SubUnitNumIdBySaleEmpeNumIdGetResponse getSubUnitNumIdBySaleEmpeNumId(
            @RequestBody SubUnitNumIdBySaleEmpeNumIdGetRequest request);

    /**
     * KOC升级申请查询
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.querySalespersonUpgradeApplyList")
    SalespersonUpgradeApplyListQueryResponse querySalespersonUpgradeApplyList(@RequestBody SalespersonUpgradeApplyListQueryRequest request);

    /**
     * KOC升级-确认升级申请
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.confirmSalespersonUpgradeApply")
    SalespersonUpgradeApplyConfirmResponse confirmSalespersonUpgradeApply(@RequestBody SalespersonUpgradeApplyConfirmRequest request);

    /**
     *  KOC升级-申请导出
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.exportSalespersonUpgradeApply")
    SalespersonUpgradeApplyExportResponse exportSalespersonUpgradeApply(@RequestBody SalespersonUpgradeApplyExportRequest request);

    /**
     * KOC升级-定时job执行升级
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.doSalespersonUpgradeForJob")
    SalespersonUpgradeForJobDoResponse doSalespersonUpgradeForJob(@RequestBody SalespersonUpgradeForJobDoRequest request);

    /**
     * 更新团队业绩
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.updateTeamDistributionCommission")
    TeamDistributionCommissionUpdateResponse updateTeamDistributionCommission(@RequestBody TeamDistributionCommissionUpdateRequest request);


    /**
     * 查询KOC详情统计
     *
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberDistributionService.statisticsDistributionSalespersonInfos")
    DistributionSalespersonInfosStatisticsResponse statisticsDistributionSalespersonInfos(@RequestBody DistributionSalespersonInfosStatisticsRequest request);

}
