package com.ykcloud.soa.social.distribution.api.service;



import com.ykcloud.soa.social.distribution.api.request.*;
import com.ykcloud.soa.social.distribution.api.response.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author lee5488
 * @version 1.0 2020/2/4
 */
@FeignClient("social-distribution")
public interface MemberShareEarnApplyService {
    /**
     * 分销员审核列表查询
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberShareEarnApplyService.queryDistributionReviewList")
    DistributionReviewListQueryResponse queryDistributionReviewList(@RequestBody DistributionReviewListQueryRequest request);

    /**
     * 批量同意、拒绝、删除
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberShareEarnApplyService.batchOperateDistributionApply")
    DistributionApplyBatchOperateResponse batchOperateDistributionApply(@RequestBody DistributionApplyBatchOperateRequest request);

    /**
     * 分销员申请提交
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberShareEarnApplyService.submitDistributionApply")
    DistributionApplySubmitResponse submitDistributionApply(@RequestBody DistributionApplySubmitRequest request);
    
    /**
     * 分销员申请提交APP专用
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberShareEarnApplyService.submitDistributionApplyForApp")
    DistributionApplySubmitForAppResponse submitDistributionApplyForApp(@RequestBody DistributionApplySubmitForAppRequest request);
    
    /**
     * 申请后7天之内可自行修改上级
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberShareEarnApplyService.distributionInviteUpdate")
    DistributionInviteUpdateResponse distributionInviteUpdate(@RequestBody DistributionInviteUpdateRequest request);
    
    /**
     * 查询会员提交申请详情
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberShareEarnApplyService.queryDistributionApply")
    DistributionApplyQueryResponse queryDistributionApply(@RequestBody DistributionApplyQueryRequest request);
    
    /**
     * 指派上级
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberShareEarnApplyService.distributionApplyAssign")
    DistributionApplyAssignResponse distributionApplyAssign(@RequestBody DistributionApplyAssignRequest request);
    
    /**
     * 添加分销员
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.MemberShareEarnApplyService.addSalespersonShareEarnLeader")
    SalespersonShareEarnLeaderAddResponse addSalespersonShareEarnLeader(@RequestBody SalespersonShareEarnLeaderAddRequest request);

}
