package com.ykcloud.soa.social.distribution.api.service;

import com.ykcloud.soa.social.distribution.api.request.*;
import com.ykcloud.soa.social.distribution.api.response.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient("social-distribution")
public interface OrderNewDistributionService {

    /**
     *  计算分销订单
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.OrderNewDistributionService.calculateDistributionOrder")
    DistributionOrderCalculateResponse calculateDistributionOrder(@RequestBody DistributionOrderCalculateRequest request);

    /**
     *  计算分销订单(POS)
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.OrderNewDistributionService.calculateDistributionOrderForPos")
    DistributionOrderForPosCalculateResponse calculateDistributionOrderForPos(@RequestBody DistributionOrderForPosCalculateRequest request);


    /**
     * 订单收益明细
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.OrderNewDistributionService.queryDistributionOrderProfitDetails")
    DistributionOrderProfitDetailsQueryResponse queryDistributionOrderProfitDetails(@RequestBody DistributionOrderProfitDetailsQueryRequest request);


    /**
     * KOC业绩查询（KOC工作台）
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.OrderNewDistributionService.getDistributionSalespersonPerformance")
    DistributionSalespersonPerformanceGetResponse getDistributionSalespersonPerformance(@RequestBody DistributionSalespersonPerformanceGetRequest request);

    /**
     * 退款完成后重新计算业绩-排除优惠券积分
     * @param request
     * @return
     */
    @PostMapping("/com.ykcloud.soa.social.distribution.api.service.OrderNewDistributionService.refreshSalePerformanceAmount")
    SalePerformanceAmountRefreshResponse refreshSalePerformanceAmount(@RequestBody SalePerformanceAmountRefreshRequest request);

}
