/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.Http;
import io.helidon.webserver.ContentTypeSelector;
import io.helidon.webserver.FileSystemContentHandler;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class ClassPathContentHandler
extends FileSystemContentHandler {
    private final ClassLoader classLoader;
    private final Map<Path, ExtractedJarEntry> extracted = new ConcurrentHashMap<Path, ExtractedJarEntry>();

    ClassPathContentHandler(String welcomeFilename, ContentTypeSelector contentTypeSelector, String root, ClassLoader classLoader) {
        super(welcomeFilename, contentTypeSelector, Paths.get(root, new String[0]));
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
    }

    @Override
    boolean doHandle(Http.RequestMethod method, Path path, ServerRequest request, ServerResponse response) throws IOException {
        String protocol;
        URL welcomeUrl;
        URL url = this.classLoader.getResource(path.toString());
        if (url == null) {
            return false;
        }
        String welcomePageName = this.getWelcomePageName();
        if (welcomePageName != null && !welcomePageName.isEmpty() && (welcomeUrl = this.classLoader.getResource(path.resolve(welcomePageName).toString())) != null) {
            url = welcomeUrl;
        }
        if ("file".equals(protocol = url.getProtocol())) {
            try {
                return super.doHandle(method, Paths.get(url.toURI()), request, response);
            }
            catch (URISyntaxException e) {
                throw new HttpException("ClassLoader resolves to invalid URI!", (Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500);
            }
        }
        if ("jar".equals(protocol)) {
            URL theUrl = url;
            ExtractedJarEntry extrEntry = this.extracted.computeIfAbsent(path, thePath -> this.extractJarEntry(theUrl));
            if (extrEntry.tempFile == null) {
                return false;
            }
            if (extrEntry.lastModified != null) {
                ClassPathContentHandler.processEtag(String.valueOf(extrEntry.lastModified.toEpochMilli()), request.headers(), response.headers());
                ClassPathContentHandler.processModifyHeaders(extrEntry.lastModified, request.headers(), response.headers());
            }
            String entryName = extrEntry.entryName == null ? ClassPathContentHandler.getFileName(path) : extrEntry.entryName;
            this.processContentType(entryName, request.headers(), response.headers());
            if (method == Http.Method.HEAD) {
                response.send();
            } else {
                response.send(extrEntry.tempFile);
            }
            return true;
        }
        throw new HttpException("Static content supports only JAR and File!", (Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private ExtractedJarEntry extractJarEntry(URL url) {
        try {
            JarURLConnection jarUrlConnection = (JarURLConnection)url.openConnection();
            JarFile jarFile = jarUrlConnection.getJarFile();
            JarEntry jarEntry = jarUrlConnection.getJarEntry();
            if (jarEntry.isDirectory()) {
                return new ExtractedJarEntry(jarEntry.getName());
            }
            Instant lastModified = this.getLastModified(url);
            try {
                try (InputStream is = jarFile.getInputStream(jarEntry);){
                    Path tempFile = Files.createTempFile("ws", ".je", new FileAttribute[0]);
                    Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
                    ExtractedJarEntry extractedJarEntry = new ExtractedJarEntry(tempFile, lastModified, jarEntry.getName());
                    return extractedJarEntry;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (!jarUrlConnection.getUseCaches()) {
                    jarFile.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new HttpException("Cannot load JAR file!", (Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500, ioe);
        }
    }

    private Instant getLastModified(URL jarUrl) throws IOException {
        Path file;
        String path = URI.create(jarUrl.getPath()).getPath();
        int jarDelimIdx = path.indexOf("!/");
        if (jarDelimIdx > -1) {
            path = path.substring(0, jarDelimIdx);
        }
        if (Files.exists(file = Paths.get(path, new String[0]), new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
            return Files.getLastModifiedTime(file, new LinkOption[0]).toInstant();
        }
        return null;
    }

    private static class ExtractedJarEntry {
        private final Path tempFile;
        private final Instant lastModified;
        private final String entryName;

        ExtractedJarEntry(Path tempFile, Instant lastModified, String entryName) {
            this.tempFile = tempFile;
            this.lastModified = lastModified;
            this.entryName = entryName;
        }

        ExtractedJarEntry(String entryName) {
            this.tempFile = null;
            this.lastModified = null;
            this.entryName = entryName;
        }
    }
}

