/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.ReactiveStreamsAdapter;
import io.helidon.common.reactive.RetrySchema;
import io.helidon.webserver.ReadableByteChannelPublisher;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class ContentWriters {
    private static final ByteArrayWriter COPY_BYTE_ARRAY_WRITER = new ByteArrayWriter(true);
    private static final ByteArrayWriter BYTE_ARRAY_WRITER = new ByteArrayWriter(false);

    private ContentWriters() {
    }

    public static Function<byte[], Flow.Publisher<DataChunk>> byteArrayWriter(boolean copy) {
        return copy ? COPY_BYTE_ARRAY_WRITER : BYTE_ARRAY_WRITER;
    }

    public static Function<CharSequence, Flow.Publisher<DataChunk>> charSequenceWriter(Charset charset) {
        CharSequenceWriter result = (CharSequenceWriter)CharSequenceWritersHolder.MAP.get(charset);
        return result == null ? new CharSequenceWriter(charset) : result;
    }

    public static Function<ReadableByteChannel, Flow.Publisher<DataChunk>> byteChannelWriter(RetrySchema retrySchema) {
        RetrySchema schema = retrySchema == null ? RetrySchema.linear((long)0L, (long)10L, (long)250L) : retrySchema;
        return channel -> new ReadableByteChannelPublisher((ReadableByteChannel)channel, schema);
    }

    public static Function<ReadableByteChannel, Flow.Publisher<DataChunk>> byteChannelWriter() {
        return ContentWriters.byteChannelWriter(null);
    }

    private static class CharSequenceWriter
    implements Function<CharSequence, Flow.Publisher<DataChunk>> {
        private final Charset charset;

        CharSequenceWriter(Charset charset) {
            Objects.requireNonNull(charset, "Parameter 'charset' is null!");
            this.charset = charset;
        }

        CharSequenceWriter(String charset) {
            this(Charset.forName(charset));
        }

        @Override
        public Flow.Publisher<DataChunk> apply(CharSequence s) {
            if (s == null || s.length() == 0) {
                return ReactiveStreamsAdapter.publisherToFlow((Publisher)Mono.empty());
            }
            DataChunk chunk = DataChunk.create((boolean)false, (ByteBuffer)this.charset.encode(s.toString()));
            return ReactiveStreamsAdapter.publisherToFlow((Publisher)Mono.just((Object)chunk));
        }
    }

    private static class ByteArrayWriter
    implements Function<byte[], Flow.Publisher<DataChunk>> {
        private final boolean copy;

        ByteArrayWriter(boolean copy) {
            this.copy = copy;
        }

        @Override
        public Flow.Publisher<DataChunk> apply(byte[] bytes) {
            byte[] bs;
            if (bytes == null || bytes.length == 0) {
                return ReactiveStreamsAdapter.publisherToFlow((Publisher)Mono.empty());
            }
            if (this.copy) {
                bs = new byte[bytes.length];
                System.arraycopy(bytes, 0, bs, 0, bytes.length);
            } else {
                bs = bytes;
            }
            DataChunk chunk = DataChunk.create((boolean)false, (ByteBuffer)ByteBuffer.wrap(bs));
            return ReactiveStreamsAdapter.publisherToFlow((Publisher)Mono.just((Object)chunk));
        }
    }

    private static final class CharSequenceWritersHolder {
        private static final Map<Charset, CharSequenceWriter> MAP = new HashMap<Charset, CharSequenceWriter>();

        private CharSequenceWritersHolder() {
        }

        private static void addWriter(Charset charset) {
            MAP.put(charset, new CharSequenceWriter(charset));
        }

        private static void addWriter(String charset) {
            try {
                CharSequenceWritersHolder.addWriter(Charset.forName(charset));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        static {
            CharSequenceWritersHolder.addWriter(StandardCharsets.UTF_8);
            CharSequenceWritersHolder.addWriter(StandardCharsets.UTF_16);
            CharSequenceWritersHolder.addWriter(StandardCharsets.ISO_8859_1);
            CharSequenceWritersHolder.addWriter(StandardCharsets.US_ASCII);
            CharSequenceWritersHolder.addWriter("cp1252");
            CharSequenceWritersHolder.addWriter("cp1250");
            CharSequenceWritersHolder.addWriter("ISO-8859-2");
        }
    }
}

