/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.MediaType;
import io.helidon.webserver.Handler;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import java.util.function.Predicate;

public interface RequestPredicate
extends Predicate<ServerRequest> {
    public RequestPredicate isOfMethod(String ... var1);

    public RequestPredicate containsHeader(String var1);

    public RequestPredicate containsHeader(String var1, Predicate<String> var2);

    public RequestPredicate containsHeader(String var1, String var2);

    public RequestPredicate containsQueryParameter(String var1);

    public RequestPredicate containsQueryParameter(String var1, Predicate<String> var2);

    public RequestPredicate containsQueryParameter(String var1, String var2);

    public RequestPredicate containsCookie(String var1);

    public RequestPredicate containsCookie(String var1, Predicate<String> var2);

    public RequestPredicate containsCookie(String var1, String var2);

    public RequestPredicate accepts(String ... var1);

    public RequestPredicate accepts(MediaType ... var1);

    public RequestPredicate hasContentType(String ... var1);

    public RequestPredicate is(Predicate<? super ServerRequest> var1);

    public ConditionalHandler thenApply(Handler var1);

    default public RequestPredicate and(Predicate<? super ServerRequest> other) {
        throw new UnsupportedOperationException();
    }

    default public RequestPredicate negate() {
        throw new UnsupportedOperationException();
    }

    default public RequestPredicate or(Predicate<? super ServerRequest> other) {
        throw new UnsupportedOperationException();
    }

    public static RequestPredicate whenRequest() {
        throw new UnsupportedOperationException();
    }

    public static RequestPredicate any(RequestPredicate ... predicates) {
        throw new UnsupportedOperationException();
    }

    public static class ConditionalHandler
    implements Handler {
        private final RequestPredicate condition;
        private final Handler acceptHandler;
        private final Handler declineHandler;

        private ConditionalHandler(RequestPredicate condition, Handler acceptHandler, Handler declineHandler) {
            this.condition = condition;
            this.acceptHandler = acceptHandler;
            this.declineHandler = declineHandler == null ? (req, res) -> req.next() : declineHandler;
        }

        ConditionalHandler(RequestPredicate condition, Handler acceptHandler) {
            this(condition, acceptHandler, null);
        }

        @Override
        public void accept(ServerRequest req, ServerResponse res) {
            if (this.condition.test(req)) {
                this.acceptHandler.accept(req, res);
            } else {
                this.declineHandler.accept(req, res);
            }
        }

        public Handler otherwise(Handler handler) {
            return new ConditionalHandler(this.condition.negate(), handler, this.acceptHandler);
        }
    }
}

