/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.Http;
import io.helidon.webserver.ErrorHandler;
import io.helidon.webserver.Handler;
import io.helidon.webserver.PathMatcher;
import io.helidon.webserver.RequestRouting;
import io.helidon.webserver.RouteListRoutingRules;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.Service;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.spi.BareRequest;
import io.helidon.webserver.spi.BareResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public interface Routing {
    public void route(BareRequest var1, BareResponse var2);

    public static Builder builder() {
        return new Builder();
    }

    default public WebServer createServer(ServerConfiguration configuration) {
        return WebServer.create(configuration, this);
    }

    default public WebServer createServer() {
        return WebServer.create(this);
    }

    public static class Builder
    implements Rules<Builder>,
    io.helidon.common.Builder<Routing> {
        private final RouteListRoutingRules delegate = new RouteListRoutingRules();
        private final List<RequestRouting.ErrorHandlerRecord<?>> errorHandlerRecords = new ArrayList();

        private Builder() {
        }

        @Override
        public Builder register(io.helidon.common.Builder<? extends Service> ... serviceBuilders) {
            this.delegate.register((io.helidon.common.Builder[])serviceBuilders);
            return this;
        }

        @Override
        public Builder register(Service ... services) {
            this.delegate.register(services);
            return this;
        }

        @Override
        public Builder register(String pathPattern, Service ... services) {
            this.delegate.register(pathPattern, services);
            return this;
        }

        @Override
        public Builder register(String pathPattern, io.helidon.common.Builder<? extends Service> ... serviceBuilders) {
            this.delegate.register(pathPattern, (io.helidon.common.Builder[])serviceBuilders);
            return this;
        }

        @Override
        public Builder get(Handler ... requestHandlers) {
            this.delegate.get(requestHandlers);
            return this;
        }

        @Override
        public Builder get(String pathPattern, Handler ... requestHandlers) {
            this.delegate.get(pathPattern, requestHandlers);
            return this;
        }

        @Override
        public Builder get(PathMatcher pathMatcher, Handler ... requestHandlers) {
            this.delegate.get(pathMatcher, requestHandlers);
            return this;
        }

        @Override
        public Builder put(Handler ... requestHandlers) {
            this.delegate.put(requestHandlers);
            return this;
        }

        @Override
        public Builder put(String pathPattern, Handler ... requestHandlers) {
            this.delegate.put(pathPattern, requestHandlers);
            return this;
        }

        @Override
        public Builder put(PathMatcher pathMatcher, Handler ... requestHandlers) {
            this.delegate.put(pathMatcher, requestHandlers);
            return this;
        }

        @Override
        public Builder post(Handler ... requestHandlers) {
            this.delegate.post(requestHandlers);
            return this;
        }

        @Override
        public Builder post(String pathPattern, Handler ... requestHandlers) {
            this.delegate.post(pathPattern, requestHandlers);
            return this;
        }

        @Override
        public Builder post(PathMatcher pathMatcher, Handler ... requestHandlers) {
            this.delegate.post(pathMatcher, requestHandlers);
            return this;
        }

        @Override
        public Builder delete(Handler ... requestHandlers) {
            this.delegate.delete(requestHandlers);
            return this;
        }

        @Override
        public Builder delete(String pathPattern, Handler ... requestHandlers) {
            this.delegate.delete(pathPattern, requestHandlers);
            return this;
        }

        @Override
        public Builder delete(PathMatcher pathMatcher, Handler ... requestHandlers) {
            this.delegate.delete(pathMatcher, requestHandlers);
            return this;
        }

        @Override
        public Builder options(Handler ... requestHandlers) {
            this.delegate.options(requestHandlers);
            return this;
        }

        @Override
        public Builder options(String pathPattern, Handler ... requestHandlers) {
            this.delegate.options(pathPattern, requestHandlers);
            return this;
        }

        @Override
        public Builder options(PathMatcher pathMatcher, Handler ... requestHandlers) {
            this.delegate.options(pathMatcher, requestHandlers);
            return this;
        }

        @Override
        public Builder head(Handler ... requestHandlers) {
            this.delegate.head(requestHandlers);
            return this;
        }

        @Override
        public Builder head(String pathPattern, Handler ... requestHandlers) {
            this.delegate.head(pathPattern, requestHandlers);
            return this;
        }

        @Override
        public Builder head(PathMatcher pathMatcher, Handler ... requestHandlers) {
            this.delegate.head(pathMatcher, requestHandlers);
            return this;
        }

        @Override
        public Builder trace(Handler ... requestHandlers) {
            this.delegate.trace(requestHandlers);
            return this;
        }

        @Override
        public Builder trace(String pathPattern, Handler ... requestHandlers) {
            this.delegate.trace(pathPattern, requestHandlers);
            return this;
        }

        @Override
        public Builder trace(PathMatcher pathMatcher, Handler ... requestHandlers) {
            this.delegate.trace(pathMatcher, requestHandlers);
            return this;
        }

        @Override
        public Builder any(Handler ... requestHandlers) {
            this.delegate.any(requestHandlers);
            return this;
        }

        @Override
        public Builder any(String pathPattern, Handler ... requestHandlers) {
            this.delegate.any(pathPattern, requestHandlers);
            return this;
        }

        @Override
        public Builder any(PathMatcher pathMatcher, Handler ... requestHandlers) {
            this.delegate.any(pathMatcher, requestHandlers);
            return this;
        }

        @Override
        public Builder anyOf(Iterable<Http.RequestMethod> methods, Handler ... requestHandlers) {
            this.delegate.anyOf((Iterable)methods, requestHandlers);
            return this;
        }

        @Override
        public Builder anyOf(Iterable<Http.RequestMethod> methods, String pathPattern, Handler ... requestHandlers) {
            this.delegate.anyOf((Iterable)methods, pathPattern, requestHandlers);
            return this;
        }

        @Override
        public Builder anyOf(Iterable<Http.RequestMethod> methods, PathMatcher pathMatcher, Handler ... requestHandlers) {
            this.delegate.anyOf((Iterable)methods, pathMatcher, requestHandlers);
            return this;
        }

        @Override
        public Builder onNewWebServer(Consumer<WebServer> webServerConsumer) {
            this.delegate.onNewWebServer((Consumer)webServerConsumer);
            return this;
        }

        public <T extends Throwable> Builder error(Class<T> exceptionClass, ErrorHandler<T> errorHandler) {
            if (errorHandler == null) {
                return this;
            }
            this.errorHandlerRecords.add(RequestRouting.ErrorHandlerRecord.of(exceptionClass, errorHandler));
            return this;
        }

        public Routing build() {
            RouteListRoutingRules.Aggregation aggregate = this.delegate.aggregate();
            return new RequestRouting(aggregate.getRouteList(), this.errorHandlerRecords, aggregate.getNewWebServerCallbacks());
        }

        public WebServer createServer(ServerConfiguration configuration) {
            return WebServer.create(configuration, this.build());
        }

        public WebServer createServer(ServerConfiguration.Builder configurationBuilder) {
            return WebServer.create(configurationBuilder.build(), this.build());
        }

        public WebServer createServer() {
            return WebServer.create(this.build());
        }
    }

    public static interface Rules<T extends Rules> {
        public T register(Service ... var1);

        public T register(io.helidon.common.Builder<? extends Service> ... var1);

        public T register(String var1, Service ... var2);

        public T register(String var1, io.helidon.common.Builder<? extends Service> ... var2);

        public T get(Handler ... var1);

        public T get(String var1, Handler ... var2);

        public T get(PathMatcher var1, Handler ... var2);

        public T put(Handler ... var1);

        public T put(String var1, Handler ... var2);

        public T put(PathMatcher var1, Handler ... var2);

        public T post(Handler ... var1);

        public T post(String var1, Handler ... var2);

        public T post(PathMatcher var1, Handler ... var2);

        public T delete(Handler ... var1);

        public T delete(String var1, Handler ... var2);

        public T delete(PathMatcher var1, Handler ... var2);

        public T options(Handler ... var1);

        public T options(String var1, Handler ... var2);

        public T options(PathMatcher var1, Handler ... var2);

        public T head(Handler ... var1);

        public T head(String var1, Handler ... var2);

        public T head(PathMatcher var1, Handler ... var2);

        public T trace(Handler ... var1);

        public T trace(String var1, Handler ... var2);

        public T trace(PathMatcher var1, Handler ... var2);

        public T any(Handler ... var1);

        public T any(String var1, Handler ... var2);

        public T any(PathMatcher var1, Handler ... var2);

        public T anyOf(Iterable<Http.RequestMethod> var1, Handler ... var2);

        public T anyOf(Iterable<Http.RequestMethod> var1, String var2, Handler ... var3);

        public T anyOf(Iterable<Http.RequestMethod> var1, PathMatcher var2, Handler ... var3);

        public T onNewWebServer(Consumer<WebServer> var1);
    }
}

