/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session.binder;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.filter.OncePerRequestHttpServerFilter;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.session.Session;
import io.micronaut.session.annotation.SessionValue;
import io.micronaut.session.http.HttpSessionFilter;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
@Requires(classes={HttpServerConfiguration.class})
public class SessionValueArgumentBinder
implements AnnotatedRequestArgumentBinder<SessionValue, Object> {
    public Class<SessionValue> getAnnotationType() {
        return SessionValue.class;
    }

    public ArgumentBinder.BindingResult<Object> bind(ArgumentConversionContext<Object> context, HttpRequest<?> source) {
        MutableConvertibleValues attrs = source.getAttributes();
        if (!attrs.contains(OncePerRequestHttpServerFilter.getKey(HttpSessionFilter.class))) {
            return ArgumentBinder.BindingResult.UNSATISFIED;
        }
        Argument argument = context.getArgument();
        String name = context.getAnnotationMetadata().stringValue(SessionValue.class).orElse(argument.getName());
        Optional existing = attrs.get(HttpSessionFilter.SESSION_ATTRIBUTE, Session.class);
        if (existing.isPresent()) {
            String finalName = name;
            Session session = (Session)existing.get();
            return () -> session.get(finalName, context);
        }
        return ArgumentBinder.BindingResult.EMPTY;
    }
}

