/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.CollectionUtils;
import io.seata.rm.datasource.undo.SQLUndoLog;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConnectionContext {
    private static final Savepoint DEFAULT_SAVEPOINT = new Savepoint(){

        @Override
        public int getSavepointId() throws SQLException {
            return 0;
        }

        @Override
        public String getSavepointName() throws SQLException {
            return "DEFAULT_SEATA_SAVEPOINT";
        }
    };
    private String xid;
    private Long branchId;
    private boolean isGlobalLockRequire;
    private Savepoint currentSavepoint = DEFAULT_SAVEPOINT;
    private boolean autoCommitChanged;
    private final Map<Savepoint, Set<String>> lockKeysBuffer = new LinkedHashMap<Savepoint, Set<String>>();
    private final Map<Savepoint, List<SQLUndoLog>> sqlUndoItemsBuffer = new LinkedHashMap<Savepoint, List<SQLUndoLog>>();
    private final List<Savepoint> savepoints = new ArrayList<Savepoint>(8);

    boolean isGlobalLockRequire() {
        return this.isGlobalLockRequire;
    }

    void setGlobalLockRequire(boolean isGlobalLockRequire) {
        this.isGlobalLockRequire = isGlobalLockRequire;
    }

    void appendLockKey(String lockKey) {
        this.lockKeysBuffer.computeIfAbsent(this.currentSavepoint, k -> new HashSet()).add(lockKey);
    }

    void appendUndoItem(SQLUndoLog sqlUndoLog) {
        this.sqlUndoItemsBuffer.computeIfAbsent(this.currentSavepoint, k -> new ArrayList()).add(sqlUndoLog);
    }

    void appendSavepoint(Savepoint savepoint) {
        this.savepoints.add(savepoint);
        this.currentSavepoint = savepoint;
    }

    public void removeSavepoint(Savepoint savepoint) {
        List<Savepoint> afterSavepoints = this.getAfterSavepoints(savepoint);
        if (null == savepoint) {
            this.sqlUndoItemsBuffer.clear();
            this.lockKeysBuffer.clear();
        } else {
            for (Savepoint sp : afterSavepoints) {
                this.sqlUndoItemsBuffer.remove(sp);
                this.lockKeysBuffer.remove(sp);
            }
        }
        this.savepoints.removeAll(afterSavepoints);
        this.currentSavepoint = this.savepoints.size() == 0 ? DEFAULT_SAVEPOINT : this.savepoints.get(this.savepoints.size() - 1);
    }

    public void releaseSavepoint(Savepoint savepoint) {
        List<Savepoint> afterSavepoints = this.getAfterSavepoints(savepoint);
        this.savepoints.removeAll(afterSavepoints);
        this.currentSavepoint = this.savepoints.size() == 0 ? DEFAULT_SAVEPOINT : this.savepoints.get(this.savepoints.size() - 1);
        for (Savepoint sp : afterSavepoints) {
            Set<String> savepointLockKeys;
            List<SQLUndoLog> savepointSQLUndoLogs = this.sqlUndoItemsBuffer.remove(sp);
            if (CollectionUtils.isNotEmpty(savepointSQLUndoLogs)) {
                this.sqlUndoItemsBuffer.computeIfAbsent(this.currentSavepoint, k -> new ArrayList(savepointSQLUndoLogs.size())).addAll(savepointSQLUndoLogs);
            }
            if (!CollectionUtils.isNotEmpty(savepointLockKeys = this.lockKeysBuffer.remove(sp))) continue;
            this.lockKeysBuffer.computeIfAbsent(this.currentSavepoint, k -> new HashSet()).addAll(savepointLockKeys);
        }
    }

    public boolean inGlobalTransaction() {
        return this.xid != null;
    }

    public boolean isBranchRegistered() {
        return this.branchId != null;
    }

    void bind(String xid) {
        if (xid == null) {
            throw new IllegalArgumentException("xid should not be null");
        }
        if (!this.inGlobalTransaction()) {
            this.setXid(xid);
        } else if (!this.xid.equals(xid)) {
            throw new ShouldNeverHappenException();
        }
    }

    public boolean hasUndoLog() {
        return !this.sqlUndoItemsBuffer.isEmpty();
    }

    public boolean hasLockKey() {
        return !this.lockKeysBuffer.isEmpty();
    }

    public String getXid() {
        return this.xid;
    }

    void setXid(String xid) {
        this.xid = xid;
    }

    public Long getBranchId() {
        return this.branchId;
    }

    void setBranchId(Long branchId) {
        this.branchId = branchId;
    }

    public boolean isAutoCommitChanged() {
        return this.autoCommitChanged;
    }

    public void setAutoCommitChanged(boolean autoCommitChanged) {
        this.autoCommitChanged = autoCommitChanged;
    }

    public void reset() {
        this.reset(null);
    }

    void reset(String xid) {
        this.xid = xid;
        this.branchId = null;
        this.isGlobalLockRequire = false;
        this.savepoints.clear();
        this.lockKeysBuffer.clear();
        this.sqlUndoItemsBuffer.clear();
        this.autoCommitChanged = false;
    }

    public String buildLockKeys() {
        if (this.lockKeysBuffer.isEmpty()) {
            return null;
        }
        HashSet<String> lockKeysBufferSet = new HashSet<String>();
        for (Set<String> lockKeys : this.lockKeysBuffer.values()) {
            lockKeysBufferSet.addAll(lockKeys);
        }
        if (lockKeysBufferSet.isEmpty()) {
            return null;
        }
        StringBuilder appender = new StringBuilder();
        Iterator iterable = lockKeysBufferSet.iterator();
        while (iterable.hasNext()) {
            appender.append((String)iterable.next());
            if (!iterable.hasNext()) continue;
            appender.append(";");
        }
        return appender.toString();
    }

    public List<SQLUndoLog> getUndoItems() {
        ArrayList<SQLUndoLog> undoItems = new ArrayList<SQLUndoLog>();
        for (List<SQLUndoLog> items : this.sqlUndoItemsBuffer.values()) {
            undoItems.addAll(items);
        }
        return undoItems;
    }

    private List<Savepoint> getAfterSavepoints(Savepoint savepoint) {
        if (null == savepoint) {
            return new ArrayList<Savepoint>(this.savepoints);
        }
        return new ArrayList<Savepoint>(this.savepoints.subList(this.savepoints.indexOf(savepoint), this.savepoints.size()));
    }

    public String toString() {
        return "ConnectionContext [xid=" + this.xid + ", branchId=" + this.branchId + ", lockKeysBuffer=" + this.lockKeysBuffer + ", sqlUndoItemsBuffer=" + this.sqlUndoItemsBuffer + "]";
    }
}

