/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.cdc.debezium.rdbms;

import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.cdc.CdcOperation;
import com.mongodb.kafka.connect.sink.cdc.debezium.OperationType;
import com.mongodb.kafka.connect.sink.cdc.debezium.rdbms.RdbmsHandler;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;

public class RdbmsDelete
implements CdcOperation {
    @Override
    public WriteModel<BsonDocument> perform(SinkDocument doc) {
        BsonDocument keyDoc = doc.getKeyDoc().orElseThrow(() -> new DataException("Key document must not be missing for delete operation"));
        BsonDocument valueDoc = doc.getValueDoc().orElseThrow(() -> new DataException("Value document must not be missing for delete operation"));
        try {
            BsonDocument filterDoc = RdbmsHandler.generateFilterDoc(keyDoc, valueDoc, OperationType.DELETE);
            return new DeleteOneModel<BsonDocument>(filterDoc);
        }
        catch (Exception exc) {
            throw new DataException((Throwable)exc);
        }
    }
}

