/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.processor.PostProcessor;
import com.mongodb.kafka.connect.util.FlexibleDateTimeParser;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDateTime;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimeseriesTimeFieldAutoConversion
extends PostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostProcessor.class);
    private final String fieldName;
    private final FlexibleDateTimeParser flexibleDateTimeParser;

    TimeseriesTimeFieldAutoConversion(MongoSinkTopicConfig config) {
        super(config);
        this.fieldName = config.getString("timeseries.timefield");
        this.flexibleDateTimeParser = new FlexibleDateTimeParser(config.getString("timeseries.timefield.auto.convert.date.format"), config.getString("timeseries.timefield.auto.convert.locale.language.tag"));
    }

    @Override
    public void process(SinkDocument doc, SinkRecord orig) {
        doc.getValueDoc().filter(d -> d.containsKey(this.fieldName) && (d.isNumber(this.fieldName) || d.isString(this.fieldName))).ifPresent(d -> {
            BsonValue timeField = d.get(this.fieldName);
            Optional<BsonDateTime> convertedValue = timeField.isNumber() ? this.tryToConvert(() -> new BsonDateTime(timeField.asNumber().longValue())) : this.tryToConvert(() -> new BsonDateTime(this.flexibleDateTimeParser.toEpochMilli(timeField.asString().getValue())));
            convertedValue.map(bsonDateTime -> d.put(this.fieldName, (BsonValue)bsonDateTime));
        });
    }

    Optional<BsonDateTime> tryToConvert(Supplier<BsonDateTime> supplier) {
        try {
            return Optional.of(supplier.get());
        }
        catch (Exception e) {
            LOGGER.info(String.format("Failed to convert field `%s` to a valid date time, so leaving as is: `%s`", this.fieldName, e.getMessage()));
            return Optional.empty();
        }
    }
}

