/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoQueryException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import io.debezium.DebeziumException;
import io.debezium.connector.mongodb.JsonSerialization;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.function.BlockingConsumer;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.Document;
import org.bson.types.Binary;
import org.slf4j.Logger;

public class MongoUtil {
    private static final String ADDRESS_DELIMITER = ",";
    public static final Pattern ADDRESS_DELIMITER_PATTERN = Pattern.compile(",");
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("([^:]+)(:(\\d+))?");
    private static final Pattern IPV6_ADDRESS_PATTERN = Pattern.compile("(\\[[^]]+\\])(:(\\d+))?");

    public static String replicaSetUsedIn(String addresses) {
        if (addresses.startsWith("[")) {
            return null;
        }
        int index = addresses.indexOf(47);
        if (index < 0) {
            return null;
        }
        return addresses.substring(0, index);
    }

    public static void forEachDatabaseName(MongoClient client, Consumer<String> operation) {
        MongoUtil.forEach(client.listDatabaseNames(), operation);
    }

    public static void forEachCollectionNameInDatabase(MongoClient client, String databaseName, Consumer<String> operation) {
        MongoDatabase db = client.getDatabase(databaseName);
        MongoUtil.forEach(db.listCollectionNames(), operation);
    }

    public static <T> void forEach(MongoIterable<T> iterable, Consumer<T> operation) {
        try (Iterator cursor = iterable.iterator();){
            while (cursor.hasNext()) {
                operation.accept(cursor.next());
            }
        }
    }

    public static void onDatabase(MongoClient client, String dbName, Consumer<MongoDatabase> dbOperation) {
        if (MongoUtil.contains(client.listDatabaseNames(), dbName)) {
            dbOperation.accept(client.getDatabase(dbName));
        }
    }

    public static void onCollection(MongoClient client, String dbName, String collectionName, Consumer<MongoCollection<Document>> collectionOperation) {
        MongoUtil.onDatabase(client, dbName, db -> {
            if (MongoUtil.contains(db.listCollectionNames(), collectionName)) {
                collectionOperation.accept(db.getCollection(collectionName));
            }
        });
    }

    public static void onCollectionDocuments(MongoClient client, String dbName, String collectionName, BlockingConsumer<Document> documentOperation) {
        MongoUtil.onCollection(client, dbName, collectionName, collection -> {
            try (Iterator cursor = collection.find().iterator();){
                while (cursor.hasNext()) {
                    try {
                        documentOperation.accept((Object)((Document)cursor.next()));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
        });
    }

    public static <T> boolean contains(MongoIterable<String> iterable, String match) {
        return MongoUtil.contains(iterable, (T v) -> Objects.equals(v, match));
    }

    public static <T> boolean contains(MongoIterable<T> iterable, Predicate<T> matcher) {
        try (Iterator cursor = iterable.iterator();){
            while (cursor.hasNext()) {
                if (!matcher.test(cursor.next())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static ServerAddress parseAddress(String addressStr) {
        if (addressStr != null) {
            Matcher matcher = ADDRESS_PATTERN.matcher(addressStr = addressStr.trim());
            if (!matcher.matches()) {
                matcher = IPV6_ADDRESS_PATTERN.matcher(addressStr);
            }
            if (matcher.matches()) {
                String host = matcher.group(1);
                String port = matcher.group(3);
                if (port == null) {
                    return new ServerAddress(host.trim());
                }
                return new ServerAddress(host.trim(), Integer.parseInt(port));
            }
        }
        return null;
    }

    public static Document getOplogEntry(MongoClient primary, int sortOrder, Logger logger) throws MongoQueryException {
        try {
            MongoCollection<Document> oplog = primary.getDatabase("local").getCollection("oplog.rs", Document.class);
            return (Document)oplog.find().sort(new Document("$natural", sortOrder)).limit(1).first();
        }
        catch (MongoQueryException e) {
            if (e.getMessage().contains("$natural:") && e.getMessage().contains("is not supported")) {
                String sortOrderType = sortOrder == -1 ? "descending" : "ascending";
                logger.info("Natural {} sort is not supported on oplog, treating situation as no oplog entry exists.", (Object)sortOrderType);
                return null;
            }
            throw e;
        }
    }

    public static String getOplogSessionTransactionId(Document oplogEvent) {
        if (!oplogEvent.containsKey("txnNumber")) {
            return null;
        }
        Document lsidDoc = (Document)((Object)oplogEvent.get((Object)"lsid", Document.class));
        Object id = lsidDoc.get("id");
        String lsid = id instanceof Binary ? UUID.nameUUIDFromBytes(((Binary)id).getData()).toString() : ((UUID)id).toString();
        Long txnNumber = oplogEvent.getLong("txnNumber");
        return lsid + ":" + txnNumber;
    }

    public static SourceInfo.SessionTransactionId getChangeStreamSessionTransactionId(ChangeStreamDocument<Document> event) {
        if (event.getLsid() == null || event.getTxnNumber() == null) {
            return null;
        }
        return new SourceInfo.SessionTransactionId(event.getLsid() == null ? null : event.getLsid().toJson(JsonSerialization.COMPACT_JSON_SETTINGS), event.getTxnNumber() == null ? null : Long.valueOf(event.getTxnNumber().longValue()));
    }

    protected static List<ServerAddress> parseAddresses(String addressStr) {
        ArrayList<ServerAddress> addresses = new ArrayList<ServerAddress>();
        if (addressStr != null) {
            addressStr = addressStr.trim();
            for (String address : ADDRESS_DELIMITER_PATTERN.split(addressStr)) {
                String hostAndPort = null;
                if (address.startsWith("[")) {
                    hostAndPort = address;
                } else {
                    int index = address.indexOf("/[");
                    if (index >= 0) {
                        if (index + 2 >= address.length()) continue;
                        hostAndPort = address.substring(index + 1);
                    } else {
                        index = address.indexOf("/");
                        hostAndPort = index >= 0 ? (index + 1 < address.length() ? address.substring(index + 1) : ServerAddress.defaultHost()) : address;
                    }
                }
                ServerAddress newAddress = MongoUtil.parseAddress(hostAndPort);
                if (newAddress == null) continue;
                addresses.add(newAddress);
            }
        }
        return addresses;
    }

    protected static String toString(ServerAddress address) {
        String host = address.getHost();
        if (host.contains(":")) {
            return "[" + host + "]:" + address.getPort();
        }
        return host + ":" + address.getPort();
    }

    protected static String toString(List<ServerAddress> addresses) {
        return Strings.join((CharSequence)ADDRESS_DELIMITER, addresses);
    }

    protected static ServerAddress getPrimaryAddress(MongoClient client) {
        ClusterDescription clusterDescription = client.getClusterDescription();
        if (clusterDescription == null || !clusterDescription.hasReadableServer(ReadPreference.primaryPreferred())) {
            client.listDatabaseNames().first();
            clusterDescription = client.getClusterDescription();
        }
        if (clusterDescription == null) {
            throw new DebeziumException("Unable to read cluster description from MongoDB connection.");
        }
        if (!clusterDescription.hasReadableServer(ReadPreference.primaryPreferred())) {
            throw new DebeziumException("Unable to use cluster description from MongoDB connection: " + clusterDescription);
        }
        List<ServerDescription> serverDescriptions = clusterDescription.getServerDescriptions();
        if (serverDescriptions == null || serverDescriptions.size() == 0) {
            throw new DebeziumException("Unable to read server descriptions from MongoDB connection (Null or empty list).");
        }
        Optional<ServerDescription> primaryDescription = serverDescriptions.stream().filter(ServerDescription::isPrimary).findFirst();
        if (!primaryDescription.isPresent()) {
            throw new DebeziumException("Unable to find primary from MongoDB connection, got '" + serverDescriptions + "'");
        }
        ServerAddress primaryAddress = primaryDescription.get().getAddress();
        return new ServerAddress(primaryAddress.getHost(), primaryAddress.getPort());
    }

    private MongoUtil() {
    }
}

