/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.client.MongoClient;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.MongoUtil;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.function.BlockingConsumer;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ReplicaSetDiscovery {
    public static final String CONFIG_DATABASE_NAME = "config";
    public static final String ADMIN_DATABASE_NAME = "admin";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicaSetDiscovery.class);
    private final MongoDbTaskContext context;
    private final String seedAddresses;

    public ReplicaSetDiscovery(MongoDbTaskContext context) {
        this.context = context;
        this.seedAddresses = context.getConnectionContext().hosts();
    }

    public ReplicaSets getReplicaSets() {
        MongoClient client = this.context.getConnectionContext().clientFor(this.seedAddresses);
        HashSet<ReplicaSet> replicaSetSpecs = new HashSet<ReplicaSet>();
        String shardsCollection = "shards";
        try {
            MongoUtil.onCollectionDocuments(client, CONFIG_DATABASE_NAME, shardsCollection, (BlockingConsumer<Document>)((BlockingConsumer)doc -> {
                LOGGER.info("Checking shard details from configuration replica set {}", (Object)this.seedAddresses);
                String shardName = doc.getString("_id");
                String hostStr = doc.getString("host");
                String replicaSetName = MongoUtil.replicaSetUsedIn(hostStr);
                replicaSetSpecs.add(new ReplicaSet(hostStr, replicaSetName, shardName));
            }));
        }
        catch (MongoInterruptedException e) {
            LOGGER.error("Interrupted while reading the '{}' collection in the '{}' database: {}", new Object[]{shardsCollection, CONFIG_DATABASE_NAME, e.getMessage(), e});
            Thread.currentThread().interrupt();
        }
        catch (MongoException e) {
            LOGGER.error("Error while reading the '{}' collection in the '{}' database: {}", new Object[]{shardsCollection, CONFIG_DATABASE_NAME, e.getMessage(), e});
        }
        if (replicaSetSpecs.isEmpty()) {
            ClusterDescription clusterDescription = client.getClusterDescription();
            LOGGER.info("Checking current members of replica set at {}", (Object)this.seedAddresses);
            if (clusterDescription != null) {
                List serverDescriptions = clusterDescription.getServerDescriptions().stream().filter(x -> x.getState() == ServerConnectionState.CONNECTED).collect(Collectors.toList());
                if (serverDescriptions.size() == 0) {
                    LOGGER.warn("Server descriptions not available, got '{}'", serverDescriptions);
                } else {
                    String addressStr = serverDescriptions.stream().map(x -> x.getAddress().toString()).collect(Collectors.joining(","));
                    String replicaSetName = ((ServerDescription)serverDescriptions.get(0)).getSetName();
                    replicaSetSpecs.add(new ReplicaSet(addressStr, replicaSetName, null));
                }
            } else {
                LOGGER.debug("Found standalone MongoDB replica set at {}", (Object)this.seedAddresses);
                String replicaSetName = MongoUtil.replicaSetUsedIn(this.seedAddresses);
                if (replicaSetName != null) {
                    for (String address : MongoUtil.ADDRESS_DELIMITER_PATTERN.split(this.seedAddresses)) {
                        replicaSetSpecs.add(new ReplicaSet(address, replicaSetName, null));
                    }
                }
            }
        }
        if (replicaSetSpecs.isEmpty()) {
            LOGGER.error("Found no replica sets at {}, so there is nothing to monitor and no connector tasks will be started. Check seed addresses in connector configuration.", (Object)this.seedAddresses);
        }
        return new ReplicaSets(replicaSetSpecs);
    }
}

