/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters;

import com.mongodb.client.MongoClient;
import io.debezium.relational.TableId;
import javax.annotation.Nonnull;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.config.MongodbSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.utils.MongodbUtils;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonNumber;

public class SplitContext {
    private final MongoClient mongoClient;
    private final TableId collectionId;
    private final BsonDocument collectionStats;
    private final int chunkSizeMB;

    public SplitContext(MongoClient mongoClient, TableId collectionId, BsonDocument collectionStats, int chunkSizeMB) {
        this.mongoClient = mongoClient;
        this.collectionId = collectionId;
        this.collectionStats = collectionStats;
        this.chunkSizeMB = chunkSizeMB;
    }

    @Nonnull
    public static SplitContext of(MongodbSourceConfig sourceConfig, TableId collectionId) {
        MongoClient mongoClient = MongodbUtils.createMongoClient(sourceConfig);
        BsonDocument collectionStats = MongodbUtils.collStats(mongoClient, collectionId);
        int chunkSizeMB = sourceConfig.getSplitSize();
        return new SplitContext(mongoClient, collectionId, collectionStats, chunkSizeMB);
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public TableId getCollectionId() {
        return this.collectionId;
    }

    public int getChunkSizeMB() {
        return this.chunkSizeMB;
    }

    public long getDocumentCount() {
        return this.getNumberValue(this.collectionStats, "count");
    }

    public long getSizeInBytes() {
        return this.getNumberValue(this.collectionStats, "size");
    }

    public long getAvgObjSizeInBytes() {
        return this.getNumberValue(this.collectionStats, "avgObjSize");
    }

    public boolean isShardedCollection() {
        return this.collectionStats.getBoolean("sharded", BsonBoolean.FALSE).getValue();
    }

    private long getNumberValue(@Nonnull BsonDocument document, String fieldName) {
        BsonNumber number = document.getNumber(fieldName, new BsonInt64(0L));
        return number.longValue();
    }
}

