/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.implement;

import cn.zhxu.bs.BeanMeta;
import cn.zhxu.bs.DbMapping;
import cn.zhxu.bs.FieldMeta;
import cn.zhxu.bs.MetaResolver;
import cn.zhxu.bs.SearchException;
import cn.zhxu.bs.SnippetResolver;
import cn.zhxu.bs.SqlSnippet;
import cn.zhxu.bs.bean.InheritType;
import cn.zhxu.bs.implement.DefaultDbMapping;
import cn.zhxu.bs.implement.DefaultSnippetResolver;
import cn.zhxu.bs.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultMetaResolver
implements MetaResolver {
    private final Map<Class<?>, BeanMeta<?>> cache = new ConcurrentHashMap();
    private SnippetResolver snippetResolver = new DefaultSnippetResolver();
    private DbMapping dbMapping;

    public DefaultMetaResolver() {
        this(new DefaultDbMapping());
    }

    public DefaultMetaResolver(DbMapping dbMapping) {
        this.dbMapping = dbMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> BeanMeta<T> resolve(Class<T> beanClass) {
        BeanMeta<Object> beanMeta = this.cache.get(beanClass);
        if (beanMeta != null) {
            return beanMeta;
        }
        Map<Class<?>, BeanMeta<?>> map = this.cache;
        synchronized (map) {
            beanMeta = this.resolveMetadata(beanClass);
            this.cache.put(beanClass, beanMeta);
            return beanMeta;
        }
    }

    protected <T> BeanMeta<T> resolveMetadata(Class<T> beanClass) {
        DbMapping.Table table = this.dbMapping.table(beanClass);
        if (table == null) {
            throw new SearchException("The class [" + beanClass.getName() + "] can not be searched, because it can not be resolved by " + this.dbMapping.getClass());
        }
        BeanMeta<T> beanMeta = new BeanMeta<T>(beanClass, table.getDataSource(), this.snippetResolver.resolve(table.getTables()), this.snippetResolver.resolve(table.getWhere()), this.snippetResolver.resolve(table.getGroupBy()), this.snippetResolver.resolve(table.getHaving()), this.snippetResolver.resolve(table.getOrderBy()), table.isSortable(), table.isDistinct(), table.getTimeout());
        FieldWrapper[] wrappers = (FieldWrapper[])this.getBeanFields(beanClass).stream().map(field -> {
            DbMapping.Column column = this.dbMapping.column(beanClass, (Field)field);
            return column != null ? new FieldWrapper((Field)field, column) : null;
        }).filter(Objects::nonNull).sorted((w1, w2) -> {
            int i1 = StringUtils.isBlank(w1.column.getAlias()) ? 1 : 0;
            int i2 = StringUtils.isBlank(w2.column.getAlias()) ? 1 : 0;
            return i1 - i2;
        }).toArray(FieldWrapper[]::new);
        HashSet<String> checkSet = new HashSet<String>();
        for (FieldWrapper wrapper : wrappers) {
            wrapper.field.setAccessible(true);
            String fieldAlias = this.resolveAlias(wrapper.column, checkSet);
            if (fieldAlias == null) {
                throw new SearchException("The alias [" + wrapper.column.getAlias() + "] of [" + beanClass.getName() + "." + wrapper.field.getName() + "] is already exists on other fields.");
            }
            checkSet.add(fieldAlias);
            SqlSnippet fieldSql = this.snippetResolver.resolve(wrapper.column.getFieldSql());
            FieldMeta fieldMeta = new FieldMeta(beanMeta, wrapper.field, fieldSql, fieldAlias, wrapper.column.isConditional(), wrapper.column.getOnlyOn(), wrapper.column.getDbType());
            beanMeta.addFieldMeta(wrapper.field.getName(), fieldMeta);
        }
        if (beanMeta.getFieldCount() == 0) {
            throw new SearchException("[" + beanClass.getName() + "] is not a valid SearchBean, because there is no field mapping to database. Please see https://bs.zhxu.cn/guide/latest/bean.html#%E7%9C%81%E7%95%A5-dbfield for help.");
        }
        return beanMeta;
    }

    protected String resolveAlias(DbMapping.Column column, Set<String> checkSet) {
        String alias = column.getAlias();
        if (StringUtils.isBlank(alias)) {
            int index = checkSet.size();
            alias = "c_" + index;
            while (checkSet.contains(alias)) {
                alias = "c_" + ++index;
            }
            return alias;
        }
        if (checkSet.contains(alias)) {
            return null;
        }
        return alias;
    }

    protected List<Field> getBeanFields(Class<?> beanClass) {
        InheritType iType = this.dbMapping.inheritType(beanClass);
        ArrayList<Field> fieldList = new ArrayList<Field>();
        HashSet<String> fieldNames = new HashSet<String>();
        while (beanClass != Object.class) {
            for (Field field : beanClass.getDeclaredFields()) {
                String name = field.getName();
                int modifiers = field.getModifiers();
                if (field.isSynthetic() || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || fieldNames.contains(name)) continue;
                fieldList.add(field);
                fieldNames.add(name);
            }
            if (iType != InheritType.FIELD && iType != InheritType.ALL) break;
            beanClass = beanClass.getSuperclass();
        }
        return fieldList;
    }

    public SnippetResolver getSnippetResolver() {
        return this.snippetResolver;
    }

    public void setSnippetResolver(SnippetResolver snippetResolver) {
        this.snippetResolver = Objects.requireNonNull(snippetResolver);
    }

    public DbMapping getDbMapping() {
        return this.dbMapping;
    }

    public void setDbMapping(DbMapping dbMapping) {
        this.dbMapping = Objects.requireNonNull(dbMapping);
    }

    public static class FieldWrapper {
        public final Field field;
        public final DbMapping.Column column;

        public FieldWrapper(Field field, DbMapping.Column column) {
            this.field = field;
            this.column = column;
        }
    }
}

