/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.util;

import cn.zhxu.bs.SearchException;
import cn.zhxu.bs.SearchParam;
import cn.zhxu.bs.param.FieldParam;
import cn.zhxu.bs.param.OrderBy;
import cn.zhxu.bs.param.Paging;
import cn.zhxu.bs.util.Builder;
import cn.zhxu.bs.util.FieldFns;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class MapBuilder
extends Builder<MapBuilder> {
    public static final String ORDER_BY = OrderBy.class.getName();
    public static final String PAGING = Paging.class.getName();
    public static final String FIELD_PARAM = FieldParam.class.getName() + UUID.randomUUID();
    public static final String ONLY_SELECT = SearchParam.class.getName() + ".ONLY_SELECT";
    public static final String SELECT_EXCLUDE = SearchParam.class.getName() + ".SELECT_EXCLUDE";
    public static final String GROUP_EXPR = SearchParam.class.getName() + ".GROUP_EXPR";

    public MapBuilder(Map<String, Object> map) {
        super(map);
    }

    public MapBuilder put(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    public MapBuilder putAll(Map<String, ?> params) {
        this.map.putAll(params);
        return this;
    }

    @SafeVarargs
    public final <T> MapBuilder onlySelect(FieldFns.FieldFn<T, ?> ... fieldFns) {
        return this.onlySelect(this.toFields(fieldFns));
    }

    public MapBuilder onlySelect(String ... fields) {
        return this.appendFields(this.obtainList(ONLY_SELECT), fields);
    }

    @SafeVarargs
    public final <T> MapBuilder selectExclude(FieldFns.FieldFn<T, ?> ... fieldFns) {
        return this.selectExclude(this.toFields(fieldFns));
    }

    public MapBuilder selectExclude(String ... fields) {
        return this.appendFields(this.obtainList(SELECT_EXCLUDE), fields);
    }

    private MapBuilder appendFields(List<String> list, String ... fields) {
        if (fields.length == 1) {
            Collections.addAll(list, fields[0].split(","));
        } else {
            Collections.addAll(list, fields);
        }
        return this;
    }

    public MapBuilder group(String group) {
        this.group = Objects.requireNonNull(group);
        return this;
    }

    public MapBuilder groupExpr(String gExpr) {
        this.map.put(GROUP_EXPR, gExpr);
        return this;
    }

    public <T> MapBuilder orderBy(FieldFns.FieldFn<T, ?> fieldFn, String order) {
        return this.orderBy(FieldFns.name(fieldFn), order);
    }

    public MapBuilder orderBy(String fieldName, String order) {
        if (fieldName != null) {
            List orderBys = this.obtainList(ORDER_BY);
            Optional<OrderBy> orderByOpt = orderBys.stream().filter(orderBy -> fieldName.equals(orderBy.getSort())).findAny();
            if (orderByOpt.isPresent()) {
                throw new SearchException("Repeated sort field: " + fieldName + " " + order);
            }
            orderBys.add(new OrderBy(fieldName, order));
        }
        return this;
    }

    public <T> MapBuilder orderBy(FieldFns.FieldFn<T, ?> fieldFn) {
        return this.orderBy(FieldFns.name(fieldFn), "asc");
    }

    public MapBuilder orderBy(String fieldName) {
        return this.orderBy(fieldName, "asc");
    }

    public MapBuilder asc() {
        List orderBys = this.obtainList(ORDER_BY);
        if (orderBys.isEmpty()) {
            throw new IllegalStateException("The method asc(..) must go after orderBy(..) method.");
        }
        int index = orderBys.size() - 1;
        OrderBy last = (OrderBy)orderBys.get(index);
        if (last.isDesc()) {
            orderBys.set(index, last.asc());
        }
        return this;
    }

    public MapBuilder asc(boolean sure) {
        if (sure) {
            return this.asc();
        }
        return this;
    }

    public MapBuilder desc() {
        List orderBys = this.obtainList(ORDER_BY);
        if (orderBys.isEmpty()) {
            throw new IllegalStateException("The method desc(..) must go after orderBy(..) method.");
        }
        int index = orderBys.size() - 1;
        OrderBy last = (OrderBy)orderBys.get(index);
        if (last.isAsc()) {
            orderBys.set(index, last.desc());
        }
        return this;
    }

    public MapBuilder desc(boolean sure) {
        if (sure) {
            return this.desc();
        }
        return this;
    }

    public MapBuilder page(long page, int size) {
        this.map.put(PAGING, new Page(size, page));
        return this;
    }

    public MapBuilder limit(long offset, int size) {
        this.map.put(PAGING, new Limit(size, offset));
        return this;
    }

    public Map<String, Object> build() {
        return this.map;
    }

    public static class Page {
        private final int size;
        private final long page;

        public Page(int size, long page) {
            this.size = size;
            this.page = page;
        }

        public int getSize() {
            return this.size;
        }

        public long getPage() {
            return this.page;
        }
    }

    public static class Limit {
        private final int size;
        private final long offset;

        public Limit(int size, long offset) {
            this.size = size;
            this.offset = offset;
        }

        public int getSize() {
            return this.size;
        }

        public long getOffset() {
            return this.offset;
        }
    }
}

