/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.spring.boot.autoconfigure;

import cn.beecp.BeeDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.creator.BasicDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.BeeCpDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.creator.Dbcp2DataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DefaultDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DruidDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.HikariDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.JndiDataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.zaxxer.hikari.HikariDataSource;
import java.util.List;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;

@Configuration
@EnableConfigurationProperties(value={DynamicDataSourceProperties.class})
public class DynamicDataSourceCreatorAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceCreatorAutoConfiguration.class);
    public static final int JNDI_ORDER = 1000;
    public static final int DRUID_ORDER = 2000;
    public static final int HIKARI_ORDER = 3000;
    public static final int BEECP_ORDER = 4000;
    public static final int DBCP2_ORDER = 5000;
    public static final int DEFAULT_ORDER = 6000;
    private final DynamicDataSourceProperties properties;

    @Primary
    @Bean
    @ConditionalOnMissingBean
    public DefaultDataSourceCreator dataSourceCreator(List<DataSourceCreator> dataSourceCreators) {
        DefaultDataSourceCreator defaultDataSourceCreator = new DefaultDataSourceCreator();
        defaultDataSourceCreator.setProperties(this.properties);
        defaultDataSourceCreator.setCreators(dataSourceCreators);
        return defaultDataSourceCreator;
    }

    @Bean
    @Order(value=6000)
    @ConditionalOnMissingBean
    public BasicDataSourceCreator basicDataSourceCreator() {
        return new BasicDataSourceCreator();
    }

    @Bean
    @Order(value=1000)
    @ConditionalOnMissingBean
    public JndiDataSourceCreator jndiDataSourceCreator() {
        return new JndiDataSourceCreator();
    }

    public DynamicDataSourceCreatorAutoConfiguration(DynamicDataSourceProperties properties) {
        this.properties = properties;
    }

    @ConditionalOnClass(value={BasicDataSource.class})
    @Configuration
    public class DBCP2DataSourceCreatorConfiguration {
        @Bean
        @Order(value=5000)
        @ConditionalOnMissingBean
        public Dbcp2DataSourceCreator dbcp2DataSourceCreator() {
            return new Dbcp2DataSourceCreator(DynamicDataSourceCreatorAutoConfiguration.this.properties.getDbcp2());
        }
    }

    @ConditionalOnClass(value={BeeDataSource.class})
    @Configuration
    public class BeeCpDataSourceCreatorConfiguration {
        @Bean
        @Order(value=4000)
        @ConditionalOnMissingBean
        public BeeCpDataSourceCreator beeCpDataSourceCreator() {
            return new BeeCpDataSourceCreator(DynamicDataSourceCreatorAutoConfiguration.this.properties.getBeecp());
        }
    }

    @ConditionalOnClass(value={HikariDataSource.class})
    @Configuration
    public class HikariDataSourceCreatorConfiguration {
        @Bean
        @Order(value=3000)
        @ConditionalOnMissingBean
        public HikariDataSourceCreator hikariDataSourceCreator() {
            return new HikariDataSourceCreator(DynamicDataSourceCreatorAutoConfiguration.this.properties.getHikari());
        }
    }

    @ConditionalOnClass(value={DruidDataSource.class})
    @Configuration
    public class DruidDataSourceCreatorConfiguration {
        @Bean
        @Order(value=2000)
        @ConditionalOnMissingBean
        public DruidDataSourceCreator druidDataSourceCreator() {
            return new DruidDataSourceCreator(DynamicDataSourceCreatorAutoConfiguration.this.properties.getDruid());
        }
    }
}

