/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Throwing;
import com.diffplug.common.collect.ImmutableList;
import com.diffplug.common.collect.Lists;
import com.diffplug.common.swt.os.OS;
import com.diffplug.gradle.FileMisc;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;

public class CmdLine {
    private List<Throwing.Runnable> actions = Lists.newArrayList();
    private boolean echoCmd = true;
    private boolean echoOutput = true;
    private static final int EXIT_VALUE_SUCCESS = 0;

    public void echoCmd(boolean echoCmd) {
        this.echoCmd = echoCmd;
    }

    public void echoOutput(boolean echoOutput) {
        this.echoOutput = echoOutput;
    }

    public void cmd(String cmd) {
        this.cmd(new File(System.getProperty("user.dir")), cmd);
    }

    public void cmd(File workingDir, String cmd) {
        this.run(() -> {
            try {
                CmdLine.runCmd(workingDir, cmd, this.echoCmd, this.echoOutput);
            }
            catch (IOException e) {
                throw new RuntimeException("cmd: " + cmd + "\ndir: " + workingDir.getAbsolutePath(), e);
            }
        });
    }

    public void rm(File fileOrDir) {
        this.run(() -> {
            if (fileOrDir.exists()) {
                FileMisc.forceDelete(fileOrDir);
            }
        });
    }

    public void copy(File src, File dst) {
        this.run(() -> {
            if (!src.exists()) {
                throw new IllegalArgumentException("copy failed: " + src.getAbsolutePath() + " does not exist.");
            }
            if (src.isDirectory()) {
                FileUtils.copyDirectory((File)src, (File)dst);
            } else {
                FileUtils.copyFile((File)src, (File)dst);
            }
        });
    }

    public void mv(File src, File dst) {
        this.run(() -> {
            if (!src.exists()) {
                throw new IllegalArgumentException("mv failed: " + src.getAbsolutePath() + " does not exist.");
            }
            if (src.isDirectory()) {
                FileUtils.moveDirectory((File)src, (File)dst);
            } else {
                FileUtils.moveFile((File)src, (File)dst);
            }
        });
    }

    public void run(Throwing.Runnable action) {
        this.actions.add(action);
    }

    public void performActions() throws Throwable {
        for (Throwing.Runnable action : this.actions) {
            action.run();
        }
    }

    public static Result runCmd(String cmd) throws IOException {
        return CmdLine.runCmd(new File(System.getProperty("user.dir")), cmd);
    }

    public static Result runCmd(File directory, String cmd) throws IOException {
        return CmdLine.runCmd(directory, cmd, true, true);
    }

    public static Result runCmd(File directory, String cmd, boolean echoCmd, boolean echoOutput) throws IOException {
        List<String> cmds = CmdLine.getPlatformCmds(cmd);
        ProcessBuilder builder = new ProcessBuilder(cmds);
        builder.directory(directory);
        Process process = builder.start();
        try {
            if (echoCmd) {
                System.out.println("cmd>" + cmd);
            }
            InputStreamCollector stdInputThread = new InputStreamCollector(process.getInputStream(), echoOutput ? System.out : null);
            InputStreamCollector stdErrorThread = new InputStreamCollector(process.getErrorStream(), echoOutput ? System.err : null);
            int exitValue = process.waitFor();
            stdInputThread.join();
            stdErrorThread.join();
            if (stdInputThread.getException() != null) {
                throw Errors.asRuntime((Throwable)stdInputThread.getException());
            }
            if (stdErrorThread.getException() != null) {
                throw Errors.asRuntime((Throwable)stdErrorThread.getException());
            }
            if (exitValue != 0) {
                throw new RuntimeException("'" + cmd + "' exited with " + exitValue);
            }
            return new Result(directory, cmd, stdInputThread.getOutput(), stdErrorThread.getOutput());
        }
        catch (InterruptedException e) {
            throw Errors.asRuntime((Throwable)e);
        }
    }

    private static List<String> getPlatformCmds(String cmd) {
        if (OS.getNative().isWindows()) {
            return Arrays.asList("cmd", "/c", cmd);
        }
        return Arrays.asList("/bin/sh", "-c", cmd);
    }

    static class InputStreamCollector
    extends Thread {
        private final InputStream iStream;
        @Nullable
        private final PrintStream pStream;
        private final ImmutableList.Builder<String> output;
        private IOException exception;

        public InputStreamCollector(InputStream is, @Nullable PrintStream ps) {
            this.iStream = Objects.requireNonNull(is);
            this.pStream = ps;
            this.output = ImmutableList.builder();
            this.start();
        }

        @Override
        public synchronized void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.iStream, Charset.defaultCharset()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.output.add((Object)line);
                    if (this.pStream == null) continue;
                    this.pStream.println(line);
                }
            }
            catch (IOException ex) {
                this.exception = ex;
            }
        }

        public synchronized ImmutableList<String> getOutput() {
            return this.output.build();
        }

        public synchronized IOException getException() {
            return this.exception;
        }
    }

    public static class Result {
        public final File directory;
        public final String cmd;
        public final ImmutableList<String> output;
        public final ImmutableList<String> error;

        public Result(File directory, String cmd, ImmutableList<String> output, ImmutableList<String> error) {
            this.directory = directory;
            this.cmd = cmd;
            this.output = output;
            this.error = error;
        }
    }
}

