/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.oomph;

import com.diffplug.gradle.oomph.InstalledJre;
import com.diffplug.gradle.oomph.InstalledJreAdder;
import com.diffplug.gradle.oomph.SetupAction;
import java.io.File;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;

public class InstalledJreAdderInternal
extends SetupAction.Internal<InstalledJreAdder> {
    InstalledJreAdderInternal(InstalledJreAdder host) {
        super(host);
    }

    @Override
    protected void runWithinEclipse() throws Throwable {
        IVMInstallType[] types;
        for (IVMInstallType type : types = JavaRuntime.getVMInstallTypes()) {
            if (!"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType".equals(type.getId())) continue;
            for (InstalledJre jreToAdd : ((InstalledJreAdder)this.host).installedJres) {
                IVMInstall realVM = this.addInstalledJre(type, jreToAdd);
                if (jreToAdd.isMarkDefault()) {
                    JavaRuntime.setDefaultVMInstall((IVMInstall)realVM, (IProgressMonitor)new NullProgressMonitor());
                }
                this.linkWithExecutionEnvironments(realVM, jreToAdd);
            }
        }
    }

    protected IVMInstall addInstalledJre(IVMInstallType type, InstalledJre jreToAdd) throws Exception {
        IVMInstall retVal = this.findJre(jreToAdd.getVersion(), jreToAdd.getInstalledLocation());
        if (retVal == null) {
            IVMInstall realVM;
            IStatus validationStatus = type.validateInstallLocation(jreToAdd.getInstalledLocation());
            if (!validationStatus.isOK()) {
                throw new CoreException(validationStatus);
            }
            VMStandin vmStandin = new VMStandin(type, EcoreUtil.generateUUID());
            vmStandin.setInstallLocation(jreToAdd.getInstalledLocation());
            vmStandin.setName("JRE for " + jreToAdd.getVersion());
            retVal = realVM = vmStandin.convertToRealVM();
        }
        return retVal;
    }

    protected void linkWithExecutionEnvironments(IVMInstall installedVm, InstalledJre jreToAdd) {
        IExecutionEnvironment[] executionEnvironments;
        if (jreToAdd.getExecutionEnvironments().isEmpty()) {
            return;
        }
        HashSet<String> execEnvsToAdd = new HashSet<String>(jreToAdd.getExecutionEnvironments());
        for (IExecutionEnvironment iExecutionEnvironment : executionEnvironments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments()) {
            if (!execEnvsToAdd.contains(iExecutionEnvironment.getId())) continue;
            iExecutionEnvironment.setDefaultVM(installedVm);
        }
    }

    private IVMInstall findJre(String version, File location) throws Exception {
        for (IVMInstallType vmInstallType : JavaRuntime.getVMInstallTypes()) {
            for (IVMInstall vmInstall : vmInstallType.getVMInstalls()) {
                File installLocation = vmInstall.getInstallLocation();
                if (!location.equals(installLocation)) continue;
                return vmInstall;
            }
        }
        return null;
    }
}

