/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher;

import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SqlSnippet;
import com.ejlchina.searcher.util.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanMeta<T> {
    private final Class<T> beanClass;
    private final String dataSource;
    private final SqlSnippet tableSnippet;
    private final SqlSnippet whereSnippet;
    private final SqlSnippet groupBySnippet;
    private final SqlSnippet havingSnippet;
    private final SqlSnippet orderBySnippet;
    private final boolean sortable;
    private final boolean distinct;
    private final Map<String, FieldMeta> fieldMetaMap = new HashMap<String, FieldMeta>();

    public BeanMeta(Class<T> beanClass, String dataSource, SqlSnippet tableSnippet, SqlSnippet whereSnippet, SqlSnippet groupBySnippet, SqlSnippet havingSnippet, SqlSnippet orderBySnippet, boolean sortable, boolean distinct) {
        this.beanClass = beanClass;
        this.dataSource = dataSource;
        this.tableSnippet = tableSnippet;
        this.whereSnippet = whereSnippet;
        this.groupBySnippet = groupBySnippet;
        this.havingSnippet = havingSnippet;
        this.orderBySnippet = orderBySnippet;
        this.sortable = sortable;
        this.distinct = distinct;
    }

    public void addFieldMeta(String field, FieldMeta meta) {
        if (this.fieldMetaMap.containsKey(field)) {
            throw new SearchException("The field [" + field + "] was already added.");
        }
        this.fieldMetaMap.put(field, meta);
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public SqlSnippet getTableSnippet() {
        return this.tableSnippet;
    }

    public String getWhere() {
        return this.whereSnippet.getSql();
    }

    public List<SqlSnippet.SqlPara> getWhereSqlParas() {
        return this.whereSnippet.getParas();
    }

    public String getGroupBy() {
        return this.groupBySnippet.getSql();
    }

    public List<SqlSnippet.SqlPara> getGroupBySqlParas() {
        return this.groupBySnippet.getParas();
    }

    public String getHaving() {
        return this.havingSnippet.getSql();
    }

    public List<SqlSnippet.SqlPara> getHavingSqlParas() {
        return this.havingSnippet.getParas();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Set<String> getFieldSet() {
        return Collections.unmodifiableSet(this.fieldMetaMap.keySet());
    }

    public int getFieldCount() {
        return this.fieldMetaMap.size();
    }

    public FieldMeta requireFieldMeta(String field) {
        FieldMeta meta = this.getFieldMeta(field);
        if (meta == null) {
            throw new IllegalStateException("No such field named: " + field);
        }
        return meta;
    }

    public FieldMeta getFieldMeta(String field) {
        if (field != null) {
            return this.fieldMetaMap.get(field);
        }
        return null;
    }

    public String getFieldSql(String field) {
        FieldMeta meta = this.requireFieldMeta(field);
        return meta.getFieldSql().getSql();
    }

    public Collection<FieldMeta> getFieldMetas() {
        return Collections.unmodifiableCollection(this.fieldMetaMap.values());
    }

    public SqlSnippet getOrderBySnippet() {
        return this.orderBySnippet;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public boolean isDistinctOrGroupBy() {
        return this.distinct || StringUtils.isNotBlank(this.groupBySnippet.getSql());
    }
}

