/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher;

import com.ejlchina.searcher.BeanReflector;
import com.ejlchina.searcher.BeanSearcher;
import com.ejlchina.searcher.FieldConvertor;
import com.ejlchina.searcher.MapSearcher;
import com.ejlchina.searcher.MetaResolver;
import com.ejlchina.searcher.ParamResolver;
import com.ejlchina.searcher.ResultFilter;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SqlExecutor;
import com.ejlchina.searcher.SqlInterceptor;
import com.ejlchina.searcher.SqlResolver;
import com.ejlchina.searcher.implement.AbstractSearcher;
import com.ejlchina.searcher.implement.DefaultBeanSearcher;
import com.ejlchina.searcher.implement.DefaultMapSearcher;
import java.util.ArrayList;
import java.util.List;

public class SearcherBuilder {
    public static BeanSearcherBuilder beanSearcher() {
        return new BeanSearcherBuilder();
    }

    public static MapSearcherBuilder mapSearcher() {
        return new MapSearcherBuilder();
    }

    public static class MapSearcherBuilder
    extends BaseSearcherBuilder<MapSearcherBuilder> {
        private final List<FieldConvertor.MFieldConvertor> convertors = new ArrayList<FieldConvertor.MFieldConvertor>();

        public MapSearcher build() {
            DefaultMapSearcher beanSearcher = new DefaultMapSearcher();
            this.buildInternal(beanSearcher);
            beanSearcher.setConvertors(this.convertors);
            return beanSearcher;
        }

        public MapSearcherBuilder addFieldConvertor(FieldConvertor.MFieldConvertor convertor) {
            if (convertor != null) {
                this.convertors.add(convertor);
            }
            return this;
        }
    }

    public static class BeanSearcherBuilder
    extends BaseSearcherBuilder<BeanSearcherBuilder> {
        private BeanReflector beanReflector;

        public BeanSearcherBuilder beanReflector(BeanReflector beanReflector) {
            this.beanReflector = beanReflector;
            return this;
        }

        public BeanSearcher build() {
            DefaultBeanSearcher beanSearcher = new DefaultBeanSearcher();
            this.buildInternal(beanSearcher);
            if (this.beanReflector != null) {
                beanSearcher.setBeanReflector(this.beanReflector);
            }
            return beanSearcher;
        }
    }

    static class BaseSearcherBuilder<Builder extends BaseSearcherBuilder<?>> {
        private ParamResolver paramResolver;
        private SqlResolver sqlResolver;
        private SqlExecutor sqlExecutor;
        private MetaResolver metaResolver;
        private final List<SqlInterceptor> interceptors = new ArrayList<SqlInterceptor>();
        private final List<ResultFilter> resultFilters = new ArrayList<ResultFilter>();

        BaseSearcherBuilder() {
        }

        public Builder paramResolver(ParamResolver paramResolver) {
            this.paramResolver = paramResolver;
            return (Builder)this;
        }

        public Builder sqlResolver(SqlResolver sqlResolver) {
            this.sqlResolver = sqlResolver;
            return (Builder)this;
        }

        public Builder sqlExecutor(SqlExecutor sqlExecutor) {
            this.sqlExecutor = sqlExecutor;
            return (Builder)this;
        }

        public Builder metaResolver(MetaResolver metaResolver) {
            this.metaResolver = metaResolver;
            return (Builder)this;
        }

        public Builder addInterceptor(SqlInterceptor interceptor) {
            if (interceptor != null) {
                this.interceptors.add(interceptor);
            }
            return (Builder)this;
        }

        public Builder addResultFilter(ResultFilter resultFilter) {
            if (resultFilter != null) {
                this.resultFilters.add(resultFilter);
            }
            return (Builder)this;
        }

        protected void buildInternal(AbstractSearcher mainSearcher) {
            if (this.paramResolver != null) {
                mainSearcher.setParamResolver(this.paramResolver);
            }
            if (this.sqlResolver != null) {
                mainSearcher.setSqlResolver(this.sqlResolver);
            }
            if (this.sqlExecutor != null) {
                mainSearcher.setSqlExecutor(this.sqlExecutor);
            } else if (mainSearcher.getSqlExecutor() == null) {
                throw new SearchException("You must set a sqlExecutor before building. ");
            }
            if (this.metaResolver != null) {
                mainSearcher.setMetaResolver(this.metaResolver);
            }
            mainSearcher.setInterceptors(this.interceptors);
            mainSearcher.setResultFilters(this.resultFilters);
        }
    }
}

