/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.filter;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.IllegalParamException;
import com.ejlchina.searcher.ParamFilter;
import java.util.Map;

public class SizeLimitParamFilter
implements ParamFilter {
    private int maxParaMapSize = 150;

    public SizeLimitParamFilter() {
    }

    public SizeLimitParamFilter(int maxParaMapSize) {
        this.maxParaMapSize = maxParaMapSize;
    }

    @Override
    public <T> Map<String, Object> doFilter(BeanMeta<T> beanMeta, Map<String, Object> paraMap) throws IllegalParamException {
        int size = paraMap.size();
        if (size > this.maxParaMapSize) {
            throw new IllegalParamException("A too large paraMap sized of " + size + ", max allowed " + this.maxParaMapSize);
        }
        return paraMap;
    }

    public int getMaxParaMapSize() {
        return this.maxParaMapSize;
    }

    public void setMaxParaMapSize(int maxParaMapSize) {
        this.maxParaMapSize = maxParaMapSize;
    }
}

