/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.BeanReflector;
import com.ejlchina.searcher.FieldConvertor;
import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.SearchException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class DefaultBeanReflector
implements BeanReflector {
    private List<FieldConvertor.BFieldConvertor> convertors;

    public DefaultBeanReflector() {
        this(new ArrayList<FieldConvertor.BFieldConvertor>());
    }

    public DefaultBeanReflector(List<FieldConvertor.BFieldConvertor> convertors) {
        this.convertors = convertors;
    }

    @Override
    public <T> T reflect(BeanMeta<T> beanMeta, Collection<FieldMeta> fetchFields, Function<String, Object> valueGetter) {
        Class<T> beanClass = beanMeta.getBeanClass();
        T bean = this.newInstance(beanClass);
        for (FieldMeta meta : fetchFields) {
            Object value = valueGetter.apply(meta.getDbAlias());
            try {
                value = this.convert(meta, value);
            }
            catch (Exception e) {
                throw new SearchException("The type of [" + beanClass + "#" + meta.getName() + "] is mismatch with it's database table field type", e);
            }
            if (value == null) continue;
            try {
                meta.getField().set(bean, value);
            }
            catch (ReflectiveOperationException e) {
                throw new SearchException("A exception occurred when setting value to [" + beanClass.getName() + "#" + meta.getName() + "], please check whether it's setter is correct.", e);
            }
        }
        return bean;
    }

    protected Object convert(FieldMeta meta, Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueType = value.getClass();
        Class<?> targetType = meta.getType();
        if (targetType.isAssignableFrom(valueType)) {
            return value;
        }
        for (FieldConvertor fieldConvertor : this.convertors) {
            if (!fieldConvertor.supports(meta, valueType)) continue;
            return fieldConvertor.convert(meta, value);
        }
        throw new SearchException("Can not convert " + valueType + " to " + targetType + " for " + meta.getBeanMeta().getBeanClass() + "#" + meta.getName() + ", please check the field type, or you can add a BFieldConvertor for it.");
    }

    protected <T> T newInstance(Class<T> beanClass) {
        try {
            return beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new SearchException("Can not instantiate [" + beanClass.getName() + "], please check whether there is a constructor without parameters on it.", e);
        }
        catch (Exception e) {
            throw new SearchException("Can not instantiate [" + beanClass.getName() + "], please check whether the constructor without parameters can be invoked without errors.", e);
        }
    }

    public List<FieldConvertor.BFieldConvertor> getConvertors() {
        return this.convertors;
    }

    public void setConvertors(List<FieldConvertor.BFieldConvertor> convertors) {
        this.convertors = Objects.requireNonNull(convertors);
    }

    public void addConvertor(FieldConvertor.BFieldConvertor convertor) {
        if (convertor != null) {
            this.convertors.add(convertor);
        }
    }
}

