/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.DbMapping;
import com.ejlchina.searcher.FieldOp;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.bean.DbField;
import com.ejlchina.searcher.bean.DbIgnore;
import com.ejlchina.searcher.bean.DbType;
import com.ejlchina.searcher.bean.InheritType;
import com.ejlchina.searcher.bean.SearchBean;
import com.ejlchina.searcher.bean.SortType;
import com.ejlchina.searcher.implement.DefaultDbTypeMapper;
import com.ejlchina.searcher.util.StringUtils;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDbMapping
implements DbMapping {
    protected static final Logger log = LoggerFactory.getLogger(DefaultDbMapping.class);
    protected static final Class<FieldOp>[] EMPTY_OPERATORS = new Class[0];
    protected static final Pattern SINGLE_TABLE_PATTERN = Pattern.compile("\\w+|\\w+\\s+\\w+");
    private DbMapping.DbTypeMapper dbTypeMapper = new DefaultDbTypeMapper();
    private String tablePrefix;
    private boolean upperCase = false;
    private boolean underlineCase = true;
    private InheritType defaultInheritType = InheritType.ALL;
    private SortType defaultSortType = SortType.ALLOW_PARAM;
    private String[] redundantSuffixes;
    private String[] ignoreFields;

    @Override
    public InheritType inheritType(Class<?> beanClass) {
        InheritType iType;
        SearchBean bean = this.getSearchBean(beanClass);
        if (bean != null && (iType = bean.inheritType()) != InheritType.DEFAULT) {
            return iType;
        }
        return this.defaultInheritType;
    }

    @Override
    public DbMapping.Table table(Class<?> beanClass) {
        SearchBean bean = this.getSearchBean(beanClass);
        if (bean != null) {
            String where = bean.where().trim();
            if (StringUtils.isBlank(where) && StringUtils.isNotBlank(where = bean.joinCond().trim())) {
                log.warn("@SearchBean.joinCond was deprecated, please use @SearchBean.where instead.");
            }
            return new DbMapping.Table(bean.dataSource().trim(), this.tables(beanClass, bean), where, bean.groupBy().trim(), bean.having().trim(), bean.distinct(), bean.orderBy(), this.sortable(bean.sortType()));
        }
        return new DbMapping.Table(this.toTableName(beanClass));
    }

    protected boolean sortable(SortType sortType) {
        if (sortType == SortType.ALLOW_PARAM) {
            return true;
        }
        if (sortType == SortType.ONLY_ENTITY) {
            return false;
        }
        return this.defaultSortType == SortType.ALLOW_PARAM;
    }

    @Override
    public DbMapping.Column column(Class<?> beanClass, Field field) {
        String fieldSql = this.dbFieldSql(beanClass, field);
        if (fieldSql == null) {
            return null;
        }
        DbField dbField = field.getAnnotation(DbField.class);
        if (dbField != null) {
            DbType dbType = dbField.type();
            if (dbType == DbType.UNKNOWN) {
                dbType = this.dbTypeMapper.map(field.getType());
            }
            return new DbMapping.Column(fieldSql, dbField.conditional(), dbField.onlyOn(), dbField.alias(), dbType);
        }
        DbType dbType = this.dbTypeMapper.map(field.getType());
        return new DbMapping.Column(fieldSql, true, EMPTY_OPERATORS, dbType);
    }

    protected SearchBean getSearchBean(Class<?> beanClass) {
        while (beanClass != Object.class) {
            SearchBean bean = beanClass.getAnnotation(SearchBean.class);
            if (bean != null) {
                return bean;
            }
            if (this.defaultInheritType != InheritType.TABLE && this.defaultInheritType != InheritType.ALL) break;
            beanClass = beanClass.getSuperclass();
        }
        return null;
    }

    protected String tables(Class<?> beanClass, SearchBean bean) {
        String tables = bean.tables();
        if (StringUtils.isBlank(tables)) {
            return this.toTableName(beanClass);
        }
        return tables.trim();
    }

    protected String toTableName(Class<?> beanClass) {
        String name = this.simplify(beanClass.getSimpleName());
        if (this.underlineCase) {
            name = StringUtils.toUnderline(name);
        }
        if (this.upperCase) {
            name = name.toUpperCase();
        }
        if (this.tablePrefix != null) {
            return this.tablePrefix + name;
        }
        return name;
    }

    protected String simplify(String className) {
        if (this.redundantSuffixes != null) {
            int length = className.length();
            for (String suffix : this.redundantSuffixes) {
                if (length <= suffix.length() || !className.endsWith(suffix)) continue;
                return className.substring(0, length - suffix.length());
            }
        }
        return className;
    }

    protected String dbFieldSql(Class<?> beanClass, Field field) {
        DbField dbField = field.getAnnotation(DbField.class);
        if (field.getAnnotation(DbIgnore.class) != null) {
            if (dbField == null) {
                return null;
            }
            throw new SearchException("[" + beanClass.getName() + ": " + field.getName() + "] is annotated by @DbField and @DbIgnore, which are mutually exclusive.");
        }
        SearchBean bean = this.getSearchBean(beanClass);
        if (bean != null && this.shouldIgnore(field, bean.ignoreFields())) {
            if (dbField == null) {
                return null;
            }
            int res = this.compareFieldToBeanAnnotation(field, beanClass);
            if (res == 0) {
                throw new SearchException("[" + beanClass.getName() + ": " + field.getName() + "] is annotated by @DbField and listed by @SearchBean.ignoreFields in same class, which are mutually exclusive.");
            }
            if (res > 0) {
                return null;
            }
        }
        if (dbField != null) {
            String fieldSql = dbField.value().trim();
            if (StringUtils.isNotBlank(fieldSql)) {
                if (fieldSql.toLowerCase().startsWith("select ")) {
                    return "(" + fieldSql + ")";
                }
                return fieldSql;
            }
        } else if (this.shouldIgnore(field, this.ignoreFields)) {
            return null;
        }
        if (bean == null) {
            return this.toColumnName(field);
        }
        String tables = bean.tables().trim();
        if (StringUtils.isBlank(tables)) {
            return this.toColumnName(field);
        }
        String tab = bean.autoMapTo().trim();
        if (StringUtils.isNotBlank(tab)) {
            return tab + "." + this.toColumnName(field);
        }
        Matcher matcher = SINGLE_TABLE_PATTERN.matcher(tables);
        if (matcher.matches()) {
            return this.toColumnName(field);
        }
        return null;
    }

    protected int compareFieldToBeanAnnotation(Field field, Class<?> beanClass) {
        int fieldLevel = 0;
        int beanLevel = 0;
        Class<?> clazz = beanClass;
        while (clazz != field.getDeclaringClass() && clazz != Object.class) {
            clazz = clazz.getSuperclass();
            ++fieldLevel;
        }
        clazz = beanClass;
        while (clazz.getAnnotation(SearchBean.class) == null && clazz != Object.class) {
            clazz = clazz.getSuperclass();
            ++beanLevel;
        }
        return fieldLevel - beanLevel;
    }

    protected boolean shouldIgnore(Field field, String[] ignoreFields) {
        if (ignoreFields != null) {
            String name = field.getName();
            for (String igField : ignoreFields) {
                if (!name.equals(igField)) continue;
                return true;
            }
        }
        return false;
    }

    protected String toColumnName(Field field) {
        String name = field.getName();
        if (this.underlineCase) {
            name = StringUtils.toUnderline(name);
        }
        return this.upperCase ? name.toUpperCase() : name;
    }

    public DbMapping.DbTypeMapper getDbTypeMapper() {
        return this.dbTypeMapper;
    }

    public void setDbTypeMapper(DbMapping.DbTypeMapper dbTypeMapper) {
        this.dbTypeMapper = Objects.requireNonNull(dbTypeMapper);
    }

    public InheritType getDefaultInheritType() {
        return this.defaultInheritType;
    }

    public void setDefaultInheritType(InheritType inheritType) {
        this.defaultInheritType = Objects.requireNonNull(inheritType);
    }

    public SortType getDefaultSortType() {
        return this.defaultSortType;
    }

    public void setDefaultSortType(SortType defaultSortType) {
        this.defaultSortType = Objects.requireNonNull(defaultSortType);
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        if (StringUtils.isNotBlank(tablePrefix)) {
            this.tablePrefix = tablePrefix.trim();
        }
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }

    public boolean isUnderlineCase() {
        return this.underlineCase;
    }

    public void setUnderlineCase(boolean underlineCase) {
        this.underlineCase = underlineCase;
    }

    public String[] getRedundantSuffixes() {
        return this.redundantSuffixes;
    }

    public void setRedundantSuffixes(String[] redundantSuffixes) {
        this.redundantSuffixes = redundantSuffixes;
    }

    public String[] getIgnoreFields() {
        return this.ignoreFields;
    }

    public void setIgnoreFields(String[] ignoreFields) {
        this.ignoreFields = ignoreFields;
    }
}

