/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dlf.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConnectionParam {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="connectionType")
    private ConnectionTypeEnum connectionType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="params")
    private Object params;

    public ConnectionParam withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConnectionParam withConnectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    public ConnectionTypeEnum getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
    }

    public ConnectionParam withParams(Object params) {
        this.params = params;
        return this;
    }

    public Object getParams() {
        return this.params;
    }

    public void setParams(Object params) {
        this.params = params;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionParam that = (ConnectionParam)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.connectionType, that.connectionType) && Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.connectionType, this.params);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectionParam {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    connectionType: ").append(this.toIndentedString(this.connectionType)).append("\n");
        sb.append("    params: ").append(this.toIndentedString(this.params)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ConnectionTypeEnum {
        public static final ConnectionTypeEnum DWS = new ConnectionTypeEnum("DWS");
        public static final ConnectionTypeEnum DLI = new ConnectionTypeEnum("DLI");
        public static final ConnectionTypeEnum SPARKSQL = new ConnectionTypeEnum("SparkSQL");
        public static final ConnectionTypeEnum HIVE = new ConnectionTypeEnum("Hive");
        public static final ConnectionTypeEnum RDS = new ConnectionTypeEnum("RDS");
        public static final ConnectionTypeEnum CLOUDTABLE = new ConnectionTypeEnum("CloudTable");
        private static final Map<String, ConnectionTypeEnum> STATIC_FIELDS = ConnectionTypeEnum.createStaticFields();
        private String value;

        private static Map<String, ConnectionTypeEnum> createStaticFields() {
            HashMap<String, ConnectionTypeEnum> map = new HashMap<String, ConnectionTypeEnum>();
            map.put("DWS", DWS);
            map.put("DLI", DLI);
            map.put("SparkSQL", SPARKSQL);
            map.put("Hive", HIVE);
            map.put("RDS", RDS);
            map.put("CloudTable", CLOUDTABLE);
            return Collections.unmodifiableMap(map);
        }

        ConnectionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ConnectionTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ConnectionTypeEnum(value));
        }

        public static ConnectionTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConnectionTypeEnum) {
                return this.value.equals(((ConnectionTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

