/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dlf.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.dlf.v1.model.DependWorkSpaceJob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class DependJob {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="jobs")
    private List<String> jobs = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="dependPeriod")
    private String dependPeriod;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="dependFailPolicy")
    private DependFailPolicyEnum dependFailPolicy;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="sameWorkSpaceJobs")
    private List<DependWorkSpaceJob> sameWorkSpaceJobs = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="otherWorkSpaceJobs")
    private List<DependWorkSpaceJob> otherWorkSpaceJobs = null;

    public DependJob withJobs(List<String> jobs) {
        this.jobs = jobs;
        return this;
    }

    public DependJob addJobsItem(String jobsItem) {
        if (this.jobs == null) {
            this.jobs = new ArrayList<String>();
        }
        this.jobs.add(jobsItem);
        return this;
    }

    public DependJob withJobs(Consumer<List<String>> jobsSetter) {
        if (this.jobs == null) {
            this.jobs = new ArrayList<String>();
        }
        jobsSetter.accept(this.jobs);
        return this;
    }

    public List<String> getJobs() {
        return this.jobs;
    }

    public void setJobs(List<String> jobs) {
        this.jobs = jobs;
    }

    public DependJob withDependPeriod(String dependPeriod) {
        this.dependPeriod = dependPeriod;
        return this;
    }

    public String getDependPeriod() {
        return this.dependPeriod;
    }

    public void setDependPeriod(String dependPeriod) {
        this.dependPeriod = dependPeriod;
    }

    public DependJob withDependFailPolicy(DependFailPolicyEnum dependFailPolicy) {
        this.dependFailPolicy = dependFailPolicy;
        return this;
    }

    public DependFailPolicyEnum getDependFailPolicy() {
        return this.dependFailPolicy;
    }

    public void setDependFailPolicy(DependFailPolicyEnum dependFailPolicy) {
        this.dependFailPolicy = dependFailPolicy;
    }

    public DependJob withSameWorkSpaceJobs(List<DependWorkSpaceJob> sameWorkSpaceJobs) {
        this.sameWorkSpaceJobs = sameWorkSpaceJobs;
        return this;
    }

    public DependJob addSameWorkSpaceJobsItem(DependWorkSpaceJob sameWorkSpaceJobsItem) {
        if (this.sameWorkSpaceJobs == null) {
            this.sameWorkSpaceJobs = new ArrayList<DependWorkSpaceJob>();
        }
        this.sameWorkSpaceJobs.add(sameWorkSpaceJobsItem);
        return this;
    }

    public DependJob withSameWorkSpaceJobs(Consumer<List<DependWorkSpaceJob>> sameWorkSpaceJobsSetter) {
        if (this.sameWorkSpaceJobs == null) {
            this.sameWorkSpaceJobs = new ArrayList<DependWorkSpaceJob>();
        }
        sameWorkSpaceJobsSetter.accept(this.sameWorkSpaceJobs);
        return this;
    }

    public List<DependWorkSpaceJob> getSameWorkSpaceJobs() {
        return this.sameWorkSpaceJobs;
    }

    public void setSameWorkSpaceJobs(List<DependWorkSpaceJob> sameWorkSpaceJobs) {
        this.sameWorkSpaceJobs = sameWorkSpaceJobs;
    }

    public DependJob withOtherWorkSpaceJobs(List<DependWorkSpaceJob> otherWorkSpaceJobs) {
        this.otherWorkSpaceJobs = otherWorkSpaceJobs;
        return this;
    }

    public DependJob addOtherWorkSpaceJobsItem(DependWorkSpaceJob otherWorkSpaceJobsItem) {
        if (this.otherWorkSpaceJobs == null) {
            this.otherWorkSpaceJobs = new ArrayList<DependWorkSpaceJob>();
        }
        this.otherWorkSpaceJobs.add(otherWorkSpaceJobsItem);
        return this;
    }

    public DependJob withOtherWorkSpaceJobs(Consumer<List<DependWorkSpaceJob>> otherWorkSpaceJobsSetter) {
        if (this.otherWorkSpaceJobs == null) {
            this.otherWorkSpaceJobs = new ArrayList<DependWorkSpaceJob>();
        }
        otherWorkSpaceJobsSetter.accept(this.otherWorkSpaceJobs);
        return this;
    }

    public List<DependWorkSpaceJob> getOtherWorkSpaceJobs() {
        return this.otherWorkSpaceJobs;
    }

    public void setOtherWorkSpaceJobs(List<DependWorkSpaceJob> otherWorkSpaceJobs) {
        this.otherWorkSpaceJobs = otherWorkSpaceJobs;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DependJob that = (DependJob)obj;
        return Objects.equals(this.jobs, that.jobs) && Objects.equals(this.dependPeriod, that.dependPeriod) && Objects.equals(this.dependFailPolicy, that.dependFailPolicy) && Objects.equals(this.sameWorkSpaceJobs, that.sameWorkSpaceJobs) && Objects.equals(this.otherWorkSpaceJobs, that.otherWorkSpaceJobs);
    }

    public int hashCode() {
        return Objects.hash(this.jobs, this.dependPeriod, this.dependFailPolicy, this.sameWorkSpaceJobs, this.otherWorkSpaceJobs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DependJob {\n");
        sb.append("    jobs: ").append(this.toIndentedString(this.jobs)).append("\n");
        sb.append("    dependPeriod: ").append(this.toIndentedString(this.dependPeriod)).append("\n");
        sb.append("    dependFailPolicy: ").append(this.toIndentedString(this.dependFailPolicy)).append("\n");
        sb.append("    sameWorkSpaceJobs: ").append(this.toIndentedString(this.sameWorkSpaceJobs)).append("\n");
        sb.append("    otherWorkSpaceJobs: ").append(this.toIndentedString(this.otherWorkSpaceJobs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class DependFailPolicyEnum {
        public static final DependFailPolicyEnum FAIL = new DependFailPolicyEnum("FAIL");
        public static final DependFailPolicyEnum IGNORE = new DependFailPolicyEnum("IGNORE");
        public static final DependFailPolicyEnum SUSPEND = new DependFailPolicyEnum("SUSPEND");
        private static final Map<String, DependFailPolicyEnum> STATIC_FIELDS = DependFailPolicyEnum.createStaticFields();
        private String value;

        private static Map<String, DependFailPolicyEnum> createStaticFields() {
            HashMap<String, DependFailPolicyEnum> map = new HashMap<String, DependFailPolicyEnum>();
            map.put("FAIL", FAIL);
            map.put("IGNORE", IGNORE);
            map.put("SUSPEND", SUSPEND);
            return Collections.unmodifiableMap(map);
        }

        DependFailPolicyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DependFailPolicyEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new DependFailPolicyEnum(value));
        }

        public static DependFailPolicyEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof DependFailPolicyEnum) {
                return this.value.equals(((DependFailPolicyEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

