/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dlf.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JobParam {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="value")
    private String value;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="paramType")
    private ParamTypeEnum paramType;

    public JobParam withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JobParam withValue(String value) {
        this.value = value;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public JobParam withParamType(ParamTypeEnum paramType) {
        this.paramType = paramType;
        return this;
    }

    public ParamTypeEnum getParamType() {
        return this.paramType;
    }

    public void setParamType(ParamTypeEnum paramType) {
        this.paramType = paramType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JobParam that = (JobParam)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.paramType, that.paramType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.paramType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobParam {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    paramType: ").append(this.toIndentedString(this.paramType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ParamTypeEnum {
        public static final ParamTypeEnum VARIABLE = new ParamTypeEnum("variable");
        public static final ParamTypeEnum CONSTANTS = new ParamTypeEnum("constants");
        private static final Map<String, ParamTypeEnum> STATIC_FIELDS = ParamTypeEnum.createStaticFields();
        private String value;

        private static Map<String, ParamTypeEnum> createStaticFields() {
            HashMap<String, ParamTypeEnum> map = new HashMap<String, ParamTypeEnum>();
            map.put("variable", VARIABLE);
            map.put("constants", CONSTANTS);
            return Collections.unmodifiableMap(map);
        }

        ParamTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ParamTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ParamTypeEnum(value));
        }

        public static ParamTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ParamTypeEnum) {
                return this.value.equals(((ParamTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

