/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dlf.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.dlf.v1.model.Condition;
import com.huaweicloud.sdk.dlf.v1.model.Cron;
import com.huaweicloud.sdk.dlf.v1.model.Event;
import com.huaweicloud.sdk.dlf.v1.model.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class Node {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="nodeType")
    private NodeTypeEnum nodeType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="location")
    private Location location;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="preNodeNames")
    private String preNodeNames;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="condition")
    private List<Condition> condition = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="nodeProperties")
    private String nodeProperties;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="pollingInterval")
    private Integer pollingInterval;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="maxExecutionTime")
    private Integer maxExecutionTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="retryTimes")
    private Integer retryTimes;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="retryInterval")
    private Integer retryInterval;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="failPolicy")
    private FailPolicyEnum failPolicy;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="eventTrigger")
    private Event eventTrigger;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="cronTrigger")
    private Cron cronTrigger;

    public Node withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Node withNodeType(NodeTypeEnum nodeType) {
        this.nodeType = nodeType;
        return this;
    }

    public NodeTypeEnum getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeTypeEnum nodeType) {
        this.nodeType = nodeType;
    }

    public Node withLocation(Location location) {
        this.location = location;
        return this;
    }

    public Node withLocation(Consumer<Location> locationSetter) {
        if (this.location == null) {
            this.location = new Location();
            locationSetter.accept(this.location);
        }
        return this;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Node withPreNodeNames(String preNodeNames) {
        this.preNodeNames = preNodeNames;
        return this;
    }

    public String getPreNodeNames() {
        return this.preNodeNames;
    }

    public void setPreNodeNames(String preNodeNames) {
        this.preNodeNames = preNodeNames;
    }

    public Node withCondition(List<Condition> condition) {
        this.condition = condition;
        return this;
    }

    public Node addConditionItem(Condition conditionItem) {
        if (this.condition == null) {
            this.condition = new ArrayList<Condition>();
        }
        this.condition.add(conditionItem);
        return this;
    }

    public Node withCondition(Consumer<List<Condition>> conditionSetter) {
        if (this.condition == null) {
            this.condition = new ArrayList<Condition>();
        }
        conditionSetter.accept(this.condition);
        return this;
    }

    public List<Condition> getCondition() {
        return this.condition;
    }

    public void setCondition(List<Condition> condition) {
        this.condition = condition;
    }

    public Node withNodeProperties(String nodeProperties) {
        this.nodeProperties = nodeProperties;
        return this;
    }

    public String getNodeProperties() {
        return this.nodeProperties;
    }

    public void setNodeProperties(String nodeProperties) {
        this.nodeProperties = nodeProperties;
    }

    public Node withPollingInterval(Integer pollingInterval) {
        this.pollingInterval = pollingInterval;
        return this;
    }

    public Integer getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(Integer pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public Node withMaxExecutionTime(Integer maxExecutionTime) {
        this.maxExecutionTime = maxExecutionTime;
        return this;
    }

    public Integer getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public void setMaxExecutionTime(Integer maxExecutionTime) {
        this.maxExecutionTime = maxExecutionTime;
    }

    public Node withRetryTimes(Integer retryTimes) {
        this.retryTimes = retryTimes;
        return this;
    }

    public Integer getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(Integer retryTimes) {
        this.retryTimes = retryTimes;
    }

    public Node withRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    public Integer getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
    }

    public Node withFailPolicy(FailPolicyEnum failPolicy) {
        this.failPolicy = failPolicy;
        return this;
    }

    public FailPolicyEnum getFailPolicy() {
        return this.failPolicy;
    }

    public void setFailPolicy(FailPolicyEnum failPolicy) {
        this.failPolicy = failPolicy;
    }

    public Node withEventTrigger(Event eventTrigger) {
        this.eventTrigger = eventTrigger;
        return this;
    }

    public Node withEventTrigger(Consumer<Event> eventTriggerSetter) {
        if (this.eventTrigger == null) {
            this.eventTrigger = new Event();
            eventTriggerSetter.accept(this.eventTrigger);
        }
        return this;
    }

    public Event getEventTrigger() {
        return this.eventTrigger;
    }

    public void setEventTrigger(Event eventTrigger) {
        this.eventTrigger = eventTrigger;
    }

    public Node withCronTrigger(Cron cronTrigger) {
        this.cronTrigger = cronTrigger;
        return this;
    }

    public Node withCronTrigger(Consumer<Cron> cronTriggerSetter) {
        if (this.cronTrigger == null) {
            this.cronTrigger = new Cron();
            cronTriggerSetter.accept(this.cronTrigger);
        }
        return this;
    }

    public Cron getCronTrigger() {
        return this.cronTrigger;
    }

    public void setCronTrigger(Cron cronTrigger) {
        this.cronTrigger = cronTrigger;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Node that = (Node)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.nodeType, that.nodeType) && Objects.equals(this.location, that.location) && Objects.equals(this.preNodeNames, that.preNodeNames) && Objects.equals(this.condition, that.condition) && Objects.equals(this.nodeProperties, that.nodeProperties) && Objects.equals(this.pollingInterval, that.pollingInterval) && Objects.equals(this.maxExecutionTime, that.maxExecutionTime) && Objects.equals(this.retryTimes, that.retryTimes) && Objects.equals(this.retryInterval, that.retryInterval) && Objects.equals(this.failPolicy, that.failPolicy) && Objects.equals(this.eventTrigger, that.eventTrigger) && Objects.equals(this.cronTrigger, that.cronTrigger);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.nodeType, this.location, this.preNodeNames, this.condition, this.nodeProperties, this.pollingInterval, this.maxExecutionTime, this.retryTimes, this.retryInterval, this.failPolicy, this.eventTrigger, this.cronTrigger);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Node {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nodeType: ").append(this.toIndentedString(this.nodeType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    preNodeNames: ").append(this.toIndentedString(this.preNodeNames)).append("\n");
        sb.append("    condition: ").append(this.toIndentedString(this.condition)).append("\n");
        sb.append("    nodeProperties: ").append(this.toIndentedString(this.nodeProperties)).append("\n");
        sb.append("    pollingInterval: ").append(this.toIndentedString(this.pollingInterval)).append("\n");
        sb.append("    maxExecutionTime: ").append(this.toIndentedString(this.maxExecutionTime)).append("\n");
        sb.append("    retryTimes: ").append(this.toIndentedString(this.retryTimes)).append("\n");
        sb.append("    retryInterval: ").append(this.toIndentedString(this.retryInterval)).append("\n");
        sb.append("    failPolicy: ").append(this.toIndentedString(this.failPolicy)).append("\n");
        sb.append("    eventTrigger: ").append(this.toIndentedString(this.eventTrigger)).append("\n");
        sb.append("    cronTrigger: ").append(this.toIndentedString(this.cronTrigger)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class FailPolicyEnum {
        public static final FailPolicyEnum FAIL = new FailPolicyEnum("FAIL");
        public static final FailPolicyEnum IGNORE = new FailPolicyEnum("IGNORE");
        public static final FailPolicyEnum SUSPEND = new FailPolicyEnum("SUSPEND");
        private static final Map<String, FailPolicyEnum> STATIC_FIELDS = FailPolicyEnum.createStaticFields();
        private String value;

        private static Map<String, FailPolicyEnum> createStaticFields() {
            HashMap<String, FailPolicyEnum> map = new HashMap<String, FailPolicyEnum>();
            map.put("FAIL", FAIL);
            map.put("IGNORE", IGNORE);
            map.put("SUSPEND", SUSPEND);
            return Collections.unmodifiableMap(map);
        }

        FailPolicyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FailPolicyEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new FailPolicyEnum(value));
        }

        public static FailPolicyEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof FailPolicyEnum) {
                return this.value.equals(((FailPolicyEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class NodeTypeEnum {
        public static final NodeTypeEnum HIVESQL = new NodeTypeEnum("HiveSQL");
        public static final NodeTypeEnum SPARKSQL = new NodeTypeEnum("SparkSQL");
        public static final NodeTypeEnum DWSSQL = new NodeTypeEnum("DWSSQL");
        public static final NodeTypeEnum DLISQL = new NodeTypeEnum("DLISQL");
        public static final NodeTypeEnum SHELL = new NodeTypeEnum("Shell");
        public static final NodeTypeEnum CDMJOB = new NodeTypeEnum("CDMJob");
        public static final NodeTypeEnum DISTRANSFERTASK = new NodeTypeEnum("DISTransferTask");
        public static final NodeTypeEnum CSJOB = new NodeTypeEnum("CSJob");
        public static final NodeTypeEnum CLOUDTABLEMANAGE = new NodeTypeEnum("CloudTableManage");
        public static final NodeTypeEnum OBSMANAGER = new NodeTypeEnum("OBSManager");
        public static final NodeTypeEnum RESTAPI = new NodeTypeEnum("RESTAPI");
        public static final NodeTypeEnum MACHINELEARNING = new NodeTypeEnum("MachineLearning");
        public static final NodeTypeEnum SMN = new NodeTypeEnum("SMN");
        public static final NodeTypeEnum MRSSPARK = new NodeTypeEnum("MRSSpark");
        public static final NodeTypeEnum MAPREDUCE = new NodeTypeEnum("MapReduce");
        public static final NodeTypeEnum DLISPARK = new NodeTypeEnum("DLISpark");
        private static final Map<String, NodeTypeEnum> STATIC_FIELDS = NodeTypeEnum.createStaticFields();
        private String value;

        private static Map<String, NodeTypeEnum> createStaticFields() {
            HashMap<String, NodeTypeEnum> map = new HashMap<String, NodeTypeEnum>();
            map.put("HiveSQL", HIVESQL);
            map.put("SparkSQL", SPARKSQL);
            map.put("DWSSQL", DWSSQL);
            map.put("DLISQL", DLISQL);
            map.put("Shell", SHELL);
            map.put("CDMJob", CDMJOB);
            map.put("DISTransferTask", DISTRANSFERTASK);
            map.put("CSJob", CSJOB);
            map.put("CloudTableManage", CLOUDTABLEMANAGE);
            map.put("OBSManager", OBSMANAGER);
            map.put("RESTAPI", RESTAPI);
            map.put("MachineLearning", MACHINELEARNING);
            map.put("SMN", SMN);
            map.put("MRSSpark", MRSSPARK);
            map.put("MapReduce", MAPREDUCE);
            map.put("DLISpark", DLISPARK);
            return Collections.unmodifiableMap(map);
        }

        NodeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NodeTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new NodeTypeEnum(value));
        }

        public static NodeTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof NodeTypeEnum) {
                return this.value.equals(((NodeTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

