/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dlf.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RealTimeNodeStatus {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="logPath")
    private String logPath;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="nodeType")
    private NodeTypeEnum nodeType;

    public RealTimeNodeStatus withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RealTimeNodeStatus withStatus(StatusEnum status) {
        this.status = status;
        return this;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public RealTimeNodeStatus withLogPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public RealTimeNodeStatus withNodeType(NodeTypeEnum nodeType) {
        this.nodeType = nodeType;
        return this;
    }

    public NodeTypeEnum getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeTypeEnum nodeType) {
        this.nodeType = nodeType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RealTimeNodeStatus that = (RealTimeNodeStatus)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.status, that.status) && Objects.equals(this.logPath, that.logPath) && Objects.equals(this.nodeType, that.nodeType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.status, this.logPath, this.nodeType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RealTimeNodeStatus {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    logPath: ").append(this.toIndentedString(this.logPath)).append("\n");
        sb.append("    nodeType: ").append(this.toIndentedString(this.nodeType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class NodeTypeEnum {
        public static final NodeTypeEnum HIVESQL = new NodeTypeEnum("HiveSQL");
        public static final NodeTypeEnum SPARKSQL = new NodeTypeEnum("SparkSQL");
        public static final NodeTypeEnum DWSSQL = new NodeTypeEnum("DWSSQL");
        public static final NodeTypeEnum DLISQL = new NodeTypeEnum("DLISQL");
        public static final NodeTypeEnum SHELL = new NodeTypeEnum("Shell");
        public static final NodeTypeEnum CDMJOB = new NodeTypeEnum("CDMJob");
        public static final NodeTypeEnum DISTRANSFERTASK = new NodeTypeEnum("DISTransferTask");
        public static final NodeTypeEnum CSJOB = new NodeTypeEnum("CSJob");
        public static final NodeTypeEnum CLOUDTABLEMANAGE = new NodeTypeEnum("CloudTableManage");
        public static final NodeTypeEnum OBSMANAGER = new NodeTypeEnum("OBSManager");
        public static final NodeTypeEnum RESTAPI = new NodeTypeEnum("RESTAPI");
        public static final NodeTypeEnum MACHINELEARNING = new NodeTypeEnum("MachineLearning");
        public static final NodeTypeEnum SMN = new NodeTypeEnum("SMN");
        public static final NodeTypeEnum MRSSPARK = new NodeTypeEnum("MRSSpark");
        public static final NodeTypeEnum MAPREDUCE = new NodeTypeEnum("MapReduce");
        public static final NodeTypeEnum DLISPARK = new NodeTypeEnum("DLISpark");
        private static final Map<String, NodeTypeEnum> STATIC_FIELDS = NodeTypeEnum.createStaticFields();
        private String value;

        private static Map<String, NodeTypeEnum> createStaticFields() {
            HashMap<String, NodeTypeEnum> map = new HashMap<String, NodeTypeEnum>();
            map.put("HiveSQL", HIVESQL);
            map.put("SparkSQL", SPARKSQL);
            map.put("DWSSQL", DWSSQL);
            map.put("DLISQL", DLISQL);
            map.put("Shell", SHELL);
            map.put("CDMJob", CDMJOB);
            map.put("DISTransferTask", DISTRANSFERTASK);
            map.put("CSJob", CSJOB);
            map.put("CloudTableManage", CLOUDTABLEMANAGE);
            map.put("OBSManager", OBSMANAGER);
            map.put("RESTAPI", RESTAPI);
            map.put("MachineLearning", MACHINELEARNING);
            map.put("SMN", SMN);
            map.put("MRSSpark", MRSSPARK);
            map.put("MapReduce", MAPREDUCE);
            map.put("DLISpark", DLISPARK);
            return Collections.unmodifiableMap(map);
        }

        NodeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NodeTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new NodeTypeEnum(value));
        }

        public static NodeTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof NodeTypeEnum) {
                return this.value.equals(((NodeTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class StatusEnum {
        public static final StatusEnum STARTTING = new StatusEnum("STARTTING");
        public static final StatusEnum NORMAL = new StatusEnum("NORMAL");
        public static final StatusEnum EXCEPTION = new StatusEnum("EXCEPTION");
        public static final StatusEnum STOPPING = new StatusEnum("STOPPING");
        public static final StatusEnum STOPPED = new StatusEnum("STOPPED");
        private static final Map<String, StatusEnum> STATIC_FIELDS = StatusEnum.createStaticFields();
        private String value;

        private static Map<String, StatusEnum> createStaticFields() {
            HashMap<String, StatusEnum> map = new HashMap<String, StatusEnum>();
            map.put("STARTTING", STARTTING);
            map.put("NORMAL", NORMAL);
            map.put("EXCEPTION", EXCEPTION);
            map.put("STOPPING", STOPPING);
            map.put("STOPPED", STOPPED);
            return Collections.unmodifiableMap(map);
        }

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new StatusEnum(value));
        }

        public static StatusEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof StatusEnum) {
                return this.value.equals(((StatusEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

