/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dlf.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.dlf.v1.model.Cron;
import com.huaweicloud.sdk.dlf.v1.model.Event;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class Schedule {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="scheType")
    private ScheTypeEnum scheType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="cron")
    private Cron cron;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="event")
    private Event event;

    public Schedule withScheType(ScheTypeEnum scheType) {
        this.scheType = scheType;
        return this;
    }

    public ScheTypeEnum getScheType() {
        return this.scheType;
    }

    public void setScheType(ScheTypeEnum scheType) {
        this.scheType = scheType;
    }

    public Schedule withCron(Cron cron) {
        this.cron = cron;
        return this;
    }

    public Schedule withCron(Consumer<Cron> cronSetter) {
        if (this.cron == null) {
            this.cron = new Cron();
            cronSetter.accept(this.cron);
        }
        return this;
    }

    public Cron getCron() {
        return this.cron;
    }

    public void setCron(Cron cron) {
        this.cron = cron;
    }

    public Schedule withEvent(Event event) {
        this.event = event;
        return this;
    }

    public Schedule withEvent(Consumer<Event> eventSetter) {
        if (this.event == null) {
            this.event = new Event();
            eventSetter.accept(this.event);
        }
        return this;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Schedule that = (Schedule)obj;
        return Objects.equals(this.scheType, that.scheType) && Objects.equals(this.cron, that.cron) && Objects.equals(this.event, that.event);
    }

    public int hashCode() {
        return Objects.hash(this.scheType, this.cron, this.event);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Schedule {\n");
        sb.append("    scheType: ").append(this.toIndentedString(this.scheType)).append("\n");
        sb.append("    cron: ").append(this.toIndentedString(this.cron)).append("\n");
        sb.append("    event: ").append(this.toIndentedString(this.event)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ScheTypeEnum {
        public static final ScheTypeEnum EXECUTE_ONCE = new ScheTypeEnum("EXECUTE_ONCE");
        public static final ScheTypeEnum CRON = new ScheTypeEnum("CRON");
        public static final ScheTypeEnum EVENT = new ScheTypeEnum("EVENT");
        private static final Map<String, ScheTypeEnum> STATIC_FIELDS = ScheTypeEnum.createStaticFields();
        private String value;

        private static Map<String, ScheTypeEnum> createStaticFields() {
            HashMap<String, ScheTypeEnum> map = new HashMap<String, ScheTypeEnum>();
            map.put("EXECUTE_ONCE", EXECUTE_ONCE);
            map.put("CRON", CRON);
            map.put("EVENT", EVENT);
            return Collections.unmodifiableMap(map);
        }

        ScheTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScheTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ScheTypeEnum(value));
        }

        public static ScheTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ScheTypeEnum) {
                return this.value.equals(((ScheTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

