/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dlf.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.core.SdkResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class ShowResourceResponse
extends SdkResponse {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="location")
    private String location;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="dependFiles")
    private List<String> dependFiles = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="desc")
    private String desc;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="directory")
    private String directory;

    public ShowResourceResponse withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ShowResourceResponse withType(TypeEnum type) {
        this.type = type;
        return this;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ShowResourceResponse withLocation(String location) {
        this.location = location;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public ShowResourceResponse withDependFiles(List<String> dependFiles) {
        this.dependFiles = dependFiles;
        return this;
    }

    public ShowResourceResponse addDependFilesItem(String dependFilesItem) {
        if (this.dependFiles == null) {
            this.dependFiles = new ArrayList<String>();
        }
        this.dependFiles.add(dependFilesItem);
        return this;
    }

    public ShowResourceResponse withDependFiles(Consumer<List<String>> dependFilesSetter) {
        if (this.dependFiles == null) {
            this.dependFiles = new ArrayList<String>();
        }
        dependFilesSetter.accept(this.dependFiles);
        return this;
    }

    public List<String> getDependFiles() {
        return this.dependFiles;
    }

    public void setDependFiles(List<String> dependFiles) {
        this.dependFiles = dependFiles;
    }

    public ShowResourceResponse withDesc(String desc) {
        this.desc = desc;
        return this;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public ShowResourceResponse withDirectory(String directory) {
        this.directory = directory;
        return this;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ShowResourceResponse that = (ShowResourceResponse)((Object)obj);
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.location, that.location) && Objects.equals(this.dependFiles, that.dependFiles) && Objects.equals(this.desc, that.desc) && Objects.equals(this.directory, that.directory);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.location, this.dependFiles, this.desc, this.directory);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShowResourceResponse {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    dependFiles: ").append(this.toIndentedString(this.dependFiles)).append("\n");
        sb.append("    desc: ").append(this.toIndentedString(this.desc)).append("\n");
        sb.append("    directory: ").append(this.toIndentedString(this.directory)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TypeEnum {
        public static final TypeEnum ARCHIVE = new TypeEnum("archive");
        public static final TypeEnum FILE = new TypeEnum("file");
        public static final TypeEnum JAR = new TypeEnum("jar");
        private static final Map<String, TypeEnum> STATIC_FIELDS = TypeEnum.createStaticFields();
        private String value;

        private static Map<String, TypeEnum> createStaticFields() {
            HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
            map.put("archive", ARCHIVE);
            map.put("file", FILE);
            map.put("jar", JAR);
            return Collections.unmodifiableMap(map);
        }

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TypeEnum(value));
        }

        public static TypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeEnum) {
                return this.value.equals(((TypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

