/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dlf.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.dlf.v1.model.ConnectionParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ImportConnectionReq {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="path")
    private String path;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="params")
    private List<ConnectionParam> params = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="sameNamePolicy")
    private SameNamePolicyEnum sameNamePolicy;

    public ImportConnectionReq withPath(String path) {
        this.path = path;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ImportConnectionReq withParams(List<ConnectionParam> params) {
        this.params = params;
        return this;
    }

    public ImportConnectionReq addParamsItem(ConnectionParam paramsItem) {
        if (this.params == null) {
            this.params = new ArrayList<ConnectionParam>();
        }
        this.params.add(paramsItem);
        return this;
    }

    public ImportConnectionReq withParams(Consumer<List<ConnectionParam>> paramsSetter) {
        if (this.params == null) {
            this.params = new ArrayList<ConnectionParam>();
        }
        paramsSetter.accept(this.params);
        return this;
    }

    public List<ConnectionParam> getParams() {
        return this.params;
    }

    public void setParams(List<ConnectionParam> params) {
        this.params = params;
    }

    public ImportConnectionReq withSameNamePolicy(SameNamePolicyEnum sameNamePolicy) {
        this.sameNamePolicy = sameNamePolicy;
        return this;
    }

    public SameNamePolicyEnum getSameNamePolicy() {
        return this.sameNamePolicy;
    }

    public void setSameNamePolicy(SameNamePolicyEnum sameNamePolicy) {
        this.sameNamePolicy = sameNamePolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportConnectionReq importConnectionReq = (ImportConnectionReq)o;
        return Objects.equals(this.path, importConnectionReq.path) && Objects.equals(this.params, importConnectionReq.params) && Objects.equals(this.sameNamePolicy, importConnectionReq.sameNamePolicy);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.params, this.sameNamePolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportConnectionReq {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    params: ").append(this.toIndentedString(this.params)).append("\n");
        sb.append("    sameNamePolicy: ").append(this.toIndentedString(this.sameNamePolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class SameNamePolicyEnum {
        public static final SameNamePolicyEnum SKIP = new SameNamePolicyEnum("SKIP");
        public static final SameNamePolicyEnum OVERWRITE = new SameNamePolicyEnum("OVERWRITE");
        private static final Map<String, SameNamePolicyEnum> STATIC_FIELDS = SameNamePolicyEnum.createStaticFields();
        private String value;

        private static Map<String, SameNamePolicyEnum> createStaticFields() {
            HashMap<String, SameNamePolicyEnum> map = new HashMap<String, SameNamePolicyEnum>();
            map.put("SKIP", SKIP);
            map.put("OVERWRITE", OVERWRITE);
            return Collections.unmodifiableMap(map);
        }

        SameNamePolicyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SameNamePolicyEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            SameNamePolicyEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new SameNamePolicyEnum(value);
            }
            return result;
        }

        public static SameNamePolicyEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            SameNamePolicyEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof SameNamePolicyEnum) {
                return this.value.equals(((SameNamePolicyEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

