/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.dlf.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.dlf.v1.model.BasicInfo;
import com.huaweicloud.sdk.dlf.v1.model.JobParam;
import com.huaweicloud.sdk.dlf.v1.model.Node;
import com.huaweicloud.sdk.dlf.v1.model.Schedule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class JobInfo {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="nodes")
    private List<Node> nodes = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="schedule")
    private Schedule schedule;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="params")
    private List<JobParam> params = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="directory")
    private String directory;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="jobType")
    private JobTypeEnum jobType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="basicConfig")
    private BasicInfo basicConfig;

    public JobInfo withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JobInfo withNodes(List<Node> nodes) {
        this.nodes = nodes;
        return this;
    }

    public JobInfo addNodesItem(Node nodesItem) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<Node>();
        }
        this.nodes.add(nodesItem);
        return this;
    }

    public JobInfo withNodes(Consumer<List<Node>> nodesSetter) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<Node>();
        }
        nodesSetter.accept(this.nodes);
        return this;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public JobInfo withSchedule(Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public JobInfo withSchedule(Consumer<Schedule> scheduleSetter) {
        if (this.schedule == null) {
            this.schedule = new Schedule();
            scheduleSetter.accept(this.schedule);
        }
        return this;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public JobInfo withParams(List<JobParam> params) {
        this.params = params;
        return this;
    }

    public JobInfo addParamsItem(JobParam paramsItem) {
        if (this.params == null) {
            this.params = new ArrayList<JobParam>();
        }
        this.params.add(paramsItem);
        return this;
    }

    public JobInfo withParams(Consumer<List<JobParam>> paramsSetter) {
        if (this.params == null) {
            this.params = new ArrayList<JobParam>();
        }
        paramsSetter.accept(this.params);
        return this;
    }

    public List<JobParam> getParams() {
        return this.params;
    }

    public void setParams(List<JobParam> params) {
        this.params = params;
    }

    public JobInfo withDirectory(String directory) {
        this.directory = directory;
        return this;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public JobInfo withJobType(JobTypeEnum jobType) {
        this.jobType = jobType;
        return this;
    }

    public JobTypeEnum getJobType() {
        return this.jobType;
    }

    public void setJobType(JobTypeEnum jobType) {
        this.jobType = jobType;
    }

    public JobInfo withBasicConfig(BasicInfo basicConfig) {
        this.basicConfig = basicConfig;
        return this;
    }

    public JobInfo withBasicConfig(Consumer<BasicInfo> basicConfigSetter) {
        if (this.basicConfig == null) {
            this.basicConfig = new BasicInfo();
            basicConfigSetter.accept(this.basicConfig);
        }
        return this;
    }

    public BasicInfo getBasicConfig() {
        return this.basicConfig;
    }

    public void setBasicConfig(BasicInfo basicConfig) {
        this.basicConfig = basicConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobInfo jobInfo = (JobInfo)o;
        return Objects.equals(this.name, jobInfo.name) && Objects.equals(this.nodes, jobInfo.nodes) && Objects.equals(this.schedule, jobInfo.schedule) && Objects.equals(this.params, jobInfo.params) && Objects.equals(this.directory, jobInfo.directory) && Objects.equals(this.jobType, jobInfo.jobType) && Objects.equals(this.basicConfig, jobInfo.basicConfig);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.nodes, this.schedule, this.params, this.directory, this.jobType, this.basicConfig);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobInfo {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nodes: ").append(this.toIndentedString(this.nodes)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    params: ").append(this.toIndentedString(this.params)).append("\n");
        sb.append("    directory: ").append(this.toIndentedString(this.directory)).append("\n");
        sb.append("    jobType: ").append(this.toIndentedString(this.jobType)).append("\n");
        sb.append("    basicConfig: ").append(this.toIndentedString(this.basicConfig)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class JobTypeEnum {
        public static final JobTypeEnum BATCH = new JobTypeEnum("BATCH");
        public static final JobTypeEnum REAL_TIME = new JobTypeEnum("REAL_TIME");
        private static final Map<String, JobTypeEnum> STATIC_FIELDS = JobTypeEnum.createStaticFields();
        private String value;

        private static Map<String, JobTypeEnum> createStaticFields() {
            HashMap<String, JobTypeEnum> map = new HashMap<String, JobTypeEnum>();
            map.put("BATCH", BATCH);
            map.put("REAL_TIME", REAL_TIME);
            return Collections.unmodifiableMap(map);
        }

        JobTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static JobTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            JobTypeEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new JobTypeEnum(value);
            }
            return result;
        }

        public static JobTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            JobTypeEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof JobTypeEnum) {
                return this.value.equals(((JobTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

