/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.source;

import com.jfinal.kit.HashKit;
import com.jfinal.kit.StrKit;
import com.jfinal.template.source.ISource;

public class StringSource
implements ISource {
    private String cacheKey;
    private StringBuilder content;

    public StringSource(String content, boolean cache) {
        this(content, cache ? HashKit.md5(content) : null);
    }

    public StringSource(String content, String cacheKey) {
        if (StrKit.isBlank(content)) {
            throw new IllegalArgumentException("content can not be blank");
        }
        this.content = new StringBuilder(content);
        this.cacheKey = cacheKey;
    }

    public StringSource(StringBuilder content, boolean cache) {
        this(content, cache && content != null ? HashKit.md5(content.toString()) : null);
    }

    public StringSource(StringBuilder content, String cacheKey) {
        if (content == null || content.length() == 0) {
            throw new IllegalArgumentException("content can not be blank");
        }
        this.content = content;
        this.cacheKey = cacheKey;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public String getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public StringBuilder getContent() {
        return this.content;
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("cacheKey : ").append(this.cacheKey).append("\n");
        sb.append("content : ").append((CharSequence)this.content).append("\n");
        return sb.toString();
    }
}

